/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.TaskIssueReporter;
import com.android.build.attribution.ui.data.InterTaskIssueUiData;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.utils.HtmlBuilder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class TaskIssueInfoPanel
extends JBPanel {
    private final TaskUiData myTaskData;
    private final TaskIssueUiData myIssue;
    private final TaskIssueReporter myIssueReporter;
    private final BuildAttributionUiAnalytics myAnalytics;

    public TaskIssueInfoPanel(TaskIssueUiData issue2, TaskIssueReporter reporter, BuildAttributionUiAnalytics analytics) {
        super((LayoutManager)new GridBagLayout());
        this.myIssue = issue2;
        this.myTaskData = issue2.getTask();
        this.myIssueReporter = reporter;
        this.myAnalytics = analytics;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.insetsBottom((int)15);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 23;
        this.add(this.createIssueDescription(), c);
        c.gridy = 1;
        c.fill = 2;
        JComponent recommendation = this.createRecommendation();
        this.add(recommendation, c);
        c.gridy = 2;
        this.add(this.createTaskInfo(), c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JBPanel(), c);
        this.withPreferredWidth(recommendation.getPreferredSize().width);
    }

    protected JComponent createIssueDescription() {
        String text = new HtmlBuilder().openHtmlBody().addHtml(this.myIssue.getExplanation()).closeHtmlBody().getHtml();
        JLabel iconLabel = new JLabel(BuildAttributionUIUtilKt.issueIcon(this.myIssue.getType()));
        DescriptionWithHelpLinkLabel issueDescription = new DescriptionWithHelpLinkLabel(text, this.myIssue.getHelpLink(), this.myAnalytics);
        JBPanel panel2 = new JBPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        panel2.add((Component)iconLabel, (Object)c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = JBUI.insetsLeft((int)5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel2.add((Component)((Object)issueDescription), (Object)c);
        return panel2;
    }

    protected JComponent createRecommendation() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(5));
        panel2.add((Component)new JBLabel("Recommendation").withFont(JBFont.label().asBold()));
        JLabel recommendation = this.createRecommendationTextLabel();
        recommendation.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        panel2.add(recommendation);
        if (this.myTaskData.getSourceType() != PluginSourceType.BUILD_SRC) {
            panel2.add((Component)this.createReportLinkLabel());
        }
        return panel2;
    }

    private JLabel createRecommendationTextLabel() {
        return new JBLabel(this.myIssue.getBuildSrcRecommendation());
    }

    private HyperlinkLabel createReportLinkLabel() {
        HyperlinkLabel recommendationLabel = new HyperlinkLabel();
        recommendationLabel.addHyperlinkListener(e -> {
            this.myAnalytics.bugReportLinkClicked();
            this.myIssueReporter.reportIssue(this.myIssue);
        });
        recommendationLabel.setHyperlinkText("Consider filing a bug to report this issue to the plugin developer. ", "Generate report.", "");
        return recommendationLabel;
    }

    protected JComponent createTaskInfo() {
        JBPanel panel2 = new JBPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.insetsBottom((int)15);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 23;
        c.fill = 0;
        panel2.add((Component)TaskIssueInfoPanel.createTaskInfo(this.myTaskData), (Object)c);
        if (this.myIssue instanceof InterTaskIssueUiData) {
            c.gridx = 1;
            c.insets = JBUI.insetsLeft((int)100);
            panel2.add((Component)TaskIssueInfoPanel.createTaskInfo(((InterTaskIssueUiData)this.myIssue).getConnectedTask()), (Object)c);
        }
        c.weightx = 1.0;
        c.fill = 1;
        ++c.gridx;
        panel2.add((Component)new JBPanel(), (Object)c);
        return panel2;
    }

    private static JComponent createTaskInfo(TaskUiData taskData) {
        String text = new HtmlBuilder().openHtmlBody().addBold(taskData.getTaskPath()).newline().add("Plugin: ").add(taskData.getPluginName()).newline().add("Type: ").add(taskData.getTaskType()).newline().add("Determined this build\u2019s duration: ").add(taskData.getOnExtendedCriticalPath() ? "Yes" : "No").newline().add("Duration: ").add(BuildAttributionUIUtilKt.durationString(taskData.getExecutionTime())).add(" / ").add(BuildAttributionUIUtilKt.percentageString(taskData.getExecutionTime())).newline().add("Executed incrementally: ").add(taskData.getExecutedIncrementally() ? "Yes" : "No").closeHtmlBody().getHtml();
        return BuildAttributionPanelsKt.htmlTextLabel(text);
    }
}

