/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.TaskIssueReportGenerator;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.ide.common.repository.GradleVersion;
import com.intellij.util.text.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u0013\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/attribution/ui/data/TaskIssueReportGenerator;", "", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "platformInformationProvider", "Lkotlin/Function0;", "", "agpVersionsProvider", "", "Lcom/android/ide/common/repository/GradleVersion;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "findAllIssueOccurrences", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "taskIssue", "generateAgpVersionsString", "generateBuildInformationText", "generateHeaderText", "pluginName", "generateIssueKey", "generatePlatformInformationText", "generateReportText", "generateReportTitle", "generateTaskExecutionText", "commonString", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "isSameIssue", "", "other", "intellij.android.build-attribution"})
public final class TaskIssueReportGenerator {
    private final BuildAttributionReportUiData reportData;
    private final Function0<String> platformInformationProvider;
    private final Function0<List<GradleVersion>> agpVersionsProvider;

    @NotNull
    public final String generateReportTitle(@NotNull TaskIssueUiData taskIssue) {
        Intrinsics.checkNotNullParameter((Object)taskIssue, (String)"taskIssue");
        return taskIssue.getBugReportTitle() + ": " + taskIssue.getTask().getPluginName() + ' ' + taskIssue.getTask().getName();
    }

    @NotNull
    public final String generateReportText(@NotNull TaskIssueUiData taskIssue) {
        Intrinsics.checkNotNullParameter((Object)taskIssue, (String)"taskIssue");
        String string = '\n' + this.generateHeaderText(taskIssue.getTask().getPluginName()) + "\n\n" + taskIssue.getType().getUiName() + '\n' + taskIssue.getBugReportBriefDescription() + "\n\nPlugin: " + taskIssue.getTask().getPluginName() + "\nTask: " + taskIssue.getTask().getName() + "\nTask type: " + taskIssue.getTask().getTaskType() + '\n' + this.generateTaskExecutionText(taskIssue) + "\n====Build information:====\n" + this.generateBuildInformationText() + "\n====Platform information:====\n" + this.generatePlatformInformationText() + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String generateHeaderText(String pluginName) {
        String date = new SimpleDateFormat("HH:mm, MMM dd, yyyy", Locale.US).format(new Date(this.reportData.getBuildSummary().getBuildFinishedTimestamp()));
        return "At " + date + ", Android Studio detected an issue with Gradle plugin " + pluginName;
    }

    private final String generateBuildInformationText() {
        String string = "\nExecution date: " + DateFormatUtil.formatDateTime((long)this.reportData.getBuildSummary().getBuildFinishedTimestamp()) + "\nTotal build duration: " + BuildAttributionUIUtilKt.durationString(this.reportData.getBuildSummary().getTotalBuildDuration()) + "\nConfiguration time: " + this.commonString(this.reportData.getBuildSummary().getConfigurationDuration()) + "\nCritical path tasks time: " + this.commonString(this.reportData.getBuildSummary().getCriticalPathDuration()) + "\nCritical path tasks size: " + this.reportData.getCriticalPathTasks().getSize() + "\nAGP versions: " + this.generateAgpVersionsString() + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String generatePlatformInformationText() {
        String string = (String)this.platformInformationProvider.invoke();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String generateTaskExecutionText(TaskIssueUiData taskIssue) {
        long l;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        List<TaskIssueUiData> occurrences = this.findAllIssueOccurrences(taskIssue);
        Object $this$sumByLong$iv = occurrences;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        Object object = $this$sumByLong$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object element$iv = object.next();
            TaskIssueUiData taskIssueUiData = (TaskIssueUiData)element$iv;
            l = sum$iv;
            boolean bl6 = false;
            long l2 = it.getTask().getExecutionTime().getTimeMs();
            sum$iv = l + l2;
        }
        l = sum$iv;
        long l3 = this.reportData.getBuildSummary().getCriticalPathDuration().getTimeMs();
        long l4 = l;
        TimeWithPercentage timeSum = new TimeWithPercentage(l4, l3);
        $this$sumByLong$iv = $this$buildString;
        String string = "Issue detected in " + occurrences.size() + " module(s), total execution time was " + this.commonString(timeSum) + ", by module:";
        boolean bl7 = false;
        StringBuilder stringBuilder2 = ((StringBuilder)$this$sumByLong$iv).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        for (TaskIssueUiData issue2 : occurrences) {
            String line = "Execution mode: " + issue2.getTask().getExecutionMode() + ", " + "time: " + this.commonString(issue2.getTask().getExecutionTime()) + ", " + "determines build duration: " + issue2.getTask().getOnExtendedCriticalPath() + ", " + "on critical path: " + issue2.getTask().getOnLogicalCriticalPath();
            StringBuilder stringBuilder3 = $this$buildString;
            object = "  " + line;
            boolean bl8 = false;
            StringBuilder stringBuilder4 = stringBuilder3.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final String generateAgpVersionsString() {
        Iterable iterable = (Iterable)this.agpVersionsProvider.invoke();
        Comparator comparator2 = Comparator.reverseOrder();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Comparator.reverseOrder()");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)iterable, comparator2), null, null, null, (int)5, null, (Function1)generateAgpVersionsString.1.INSTANCE, (int)23, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TaskIssueUiData> findAllIssueOccurrences(TaskIssueUiData taskIssue) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.reportData.getIssues();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TaskIssuesGroup it = (TaskIssuesGroup)element$iv2;
                boolean bl = false;
                if (!(it.getType() == taskIssue.getType())) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Iterable $this$filter$iv = ((TaskIssuesGroup)element$iv2).getIssues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TaskIssueUiData it = (TaskIssueUiData)element$iv$iv;
            boolean bl = false;
            if (!this.isSameIssue(it, taskIssue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String generateIssueKey(@NotNull TaskIssueUiData taskIssue) {
        Intrinsics.checkNotNullParameter((Object)taskIssue, (String)"taskIssue");
        return taskIssue.getTask().getPluginName() + '_' + taskIssue.getTask().getName() + '_' + Reflection.getOrCreateKotlinClass(taskIssue.getClass()).getSimpleName();
    }

    private final String commonString(TimeWithPercentage $this$commonString) {
        return BuildAttributionUIUtilKt.durationString($this$commonString) + " (" + BuildAttributionUIUtilKt.percentageString($this$commonString) + ')';
    }

    private final boolean isSameIssue(TaskIssueUiData $this$isSameIssue, TaskIssueUiData other) {
        return Intrinsics.areEqual((Object)$this$isSameIssue.getTask().getName(), (Object)other.getTask().getName()) && Intrinsics.areEqual((Object)$this$isSameIssue.getTask().getPluginName(), (Object)other.getTask().getPluginName()) && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass($this$isSameIssue.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()));
    }

    public TaskIssueReportGenerator(@NotNull BuildAttributionReportUiData reportData, @NotNull Function0<String> platformInformationProvider, @NotNull Function0<? extends List<? extends GradleVersion>> agpVersionsProvider) {
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter(platformInformationProvider, (String)"platformInformationProvider");
        Intrinsics.checkNotNullParameter(agpVersionsProvider, (String)"agpVersionsProvider");
        this.reportData = reportData;
        this.platformInformationProvider = platformInformationProvider;
        this.agpVersionsProvider = agpVersionsProvider;
    }
}

