/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt$WhenMappings;
import com.android.build.attribution.ui.MergedIcon;
import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.TaskIssueType;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u001d\u001a\n\u0010\u001e\u001a\u00020\u0005*\u00020\u001d\u00a8\u0006\u001f"}, d2={"colorIcon", "Ljavax/swing/Icon;", "color", "Ljava/awt/Color;", "durationString", "", "timeMs", "", "emptyIcon", "infoCountString", "infoCount", "", "infoIcon", "issueIcon", "issueType", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "issuesCountString", "warningsCount", "mergedIcon", "left", "right", "pluginIcon", "pluginData", "Lcom/android/build/attribution/ui/data/CriticalPathPluginUiData;", "taskIcon", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "warningIcon", "warningsCountString", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "percentageString", "intellij.android.build-attribution"})
public final class BuildAttributionUIUtilKt {
    @NotNull
    public static final String durationString(@NotNull TimeWithPercentage $this$durationString) {
        Intrinsics.checkNotNullParameter((Object)$this$durationString, (String)"$this$durationString");
        return BuildAttributionUIUtilKt.durationString($this$durationString.getTimeMs());
    }

    @NotNull
    public static final String percentageString(@NotNull TimeWithPercentage $this$percentageString) {
        Intrinsics.checkNotNullParameter((Object)$this$percentageString, (String)"$this$percentageString");
        String string = "%.1f%%";
        Object[] objectArray = new Object[]{$this$percentageString.getPercentage()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String durationString(long timeMs) {
        String string = "%.3f s";
        Object[] objectArray = new Object[]{(double)timeMs / (double)1000};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String issuesCountString(int warningsCount, int infoCount) {
        return warningsCount > 0 && infoCount > 0 ? BuildAttributionUIUtilKt.warningsCountString(warningsCount) + ", " + BuildAttributionUIUtilKt.infoCountString(infoCount) : (warningsCount == 0 && infoCount > 0 ? BuildAttributionUIUtilKt.infoCountString(infoCount) : (warningsCount > 0 && infoCount == 0 ? BuildAttributionUIUtilKt.warningsCountString(warningsCount) : ""));
    }

    @NotNull
    public static final String warningsCountString(int warningsCount) {
        return "" + warningsCount + ' ' + StringUtil.pluralize((String)"warning", (int)warningsCount);
    }

    @NotNull
    public static final String infoCountString(int infoCount) {
        return infoCount + " info";
    }

    @NotNull
    public static final Icon colorIcon(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        JBScalableIcon jBScalableIcon = JBUI.scale((JBScalableIcon)((JBScalableIcon)new ColorIcon(12, color)));
        Intrinsics.checkNotNullExpressionValue((Object)jBScalableIcon, (String)"JBUI.scale(ColorIcon(12, color))");
        return (Icon)jBScalableIcon;
    }

    @NotNull
    public static final Icon warningIcon() {
        Icon icon2 = AllIcons.General.BalloonWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.General.BalloonWarning");
        return icon2;
    }

    @NotNull
    public static final Icon infoIcon() {
        Icon icon2 = AllIcons.General.BalloonInformation;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.General.BalloonInformation");
        return icon2;
    }

    @NotNull
    public static final Icon emptyIcon() {
        Icon icon2 = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EmptyIcon.ICON_16");
        return icon2;
    }

    @NotNull
    public static final Icon mergedIcon(@NotNull Icon left2, @NotNull Icon right2) {
        Intrinsics.checkNotNullParameter((Object)left2, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        return new MergedIcon(left2, JBUI.scale((int)6), right2);
    }

    @NotNull
    public static final Icon issueIcon(@NotNull TaskIssueType issueType) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)((Object)issueType), (String)"issueType");
        switch (BuildAttributionUIUtilKt$WhenMappings.$EnumSwitchMapping$0[issueType.getLevel().ordinal()]) {
            case 1: {
                icon2 = BuildAttributionUIUtilKt.warningIcon();
                break;
            }
            case 2: {
                icon2 = BuildAttributionUIUtilKt.infoIcon();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon2;
    }

    @NotNull
    public static final Icon taskIcon(@NotNull TaskUiData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        return taskData.getHasWarning() ? BuildAttributionUIUtilKt.warningIcon() : (taskData.getHasInfo() ? BuildAttributionUIUtilKt.infoIcon() : BuildAttributionUIUtilKt.emptyIcon());
    }

    @NotNull
    public static final Icon pluginIcon(@NotNull CriticalPathPluginUiData pluginData) {
        Intrinsics.checkNotNullParameter((Object)pluginData, (String)"pluginData");
        return pluginData.getWarningCount() > 0 ? BuildAttributionUIUtilKt.warningIcon() : (pluginData.getInfoCount() > 0 ? BuildAttributionUIUtilKt.infoIcon() : BuildAttributionUIUtilKt.emptyIcon());
    }
}

