/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.data.AnnotationProcessorData;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.java.JavaCompileTaskOperationResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\bH\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "warningsFilter", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "(Lcom/android/build/attribution/BuildAttributionWarningsFilter;)V", "annotationProcessorsMap", "Ljava/util/HashMap;", "", "Ljava/time/Duration;", "Lkotlin/collections/HashMap;", "nonIncrementalAnnotationProcessorsSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getWarningsFilter", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "getAnnotationProcessorsData", "", "Lcom/android/build/attribution/data/AnnotationProcessorData;", "getNonIncrementalAnnotationProcessorsData", "onBuildFailure", "", "onBuildStart", "onBuildSuccess", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "updateAnnotationProcessorCompilationTime", "className", "compilationDuration", "intellij.android.build-attribution"})
public final class AnnotationProcessorsAnalyzer
implements BuildEventsAnalyzer {
    private final HashMap<String, Duration> annotationProcessorsMap;
    private final HashSet<String> nonIncrementalAnnotationProcessorsSet;
    @NotNull
    private final BuildAttributionWarningsFilter warningsFilter;

    private final void updateAnnotationProcessorCompilationTime(String className, Duration compilationDuration) {
        Duration duration = this.annotationProcessorsMap.getOrDefault(className, Duration.ZERO);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"annotationProcessorsMap.\u2026className, Duration.ZERO)");
        Duration currentDuration = duration;
        Map map2 = this.annotationProcessorsMap;
        Duration duration2 = currentDuration.plus(compilationDuration);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"currentDuration + compilationDuration");
        map2.put(className, duration2);
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        TaskOperationResult result2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof TaskFinishEvent && (result2 = ((TaskFinishEvent)event).getResult()) instanceof JavaCompileTaskOperationResult) {
            List list = ((JavaCompileTaskOperationResult)result2).getAnnotationProcessorResults();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JavaCompileTaskOperationResult.AnnotationProcessorResult it = (JavaCompileTaskOperationResult.AnnotationProcessorResult)element$iv;
                    boolean bl = false;
                    JavaCompileTaskOperationResult.AnnotationProcessorResult annotationProcessorResult = it;
                    Intrinsics.checkNotNullExpressionValue((Object)annotationProcessorResult, (String)"it");
                    String string = annotationProcessorResult.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                    Duration duration = it.getDuration();
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"it.duration");
                    this.updateAnnotationProcessorCompilationTime(string, duration);
                    if (it.getType() != JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.UNKNOWN) continue;
                    BuildAttributionWarningsFilter buildAttributionWarningsFilter = this.getWarningsFilter();
                    String string2 = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.className");
                    if (!buildAttributionWarningsFilter.applyNonIncrementalAnnotationProcessorFilter(string2)) continue;
                    this.nonIncrementalAnnotationProcessorsSet.add(it.getClassName());
                }
            }
        }
    }

    @Override
    public void onBuildStart() {
        this.annotationProcessorsMap.clear();
        this.nonIncrementalAnnotationProcessorsSet.clear();
    }

    @Override
    public void onBuildSuccess() {
    }

    @Override
    public void onBuildFailure() {
        this.annotationProcessorsMap.clear();
        this.nonIncrementalAnnotationProcessorsSet.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnnotationProcessorData> getAnnotationProcessorsData() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.annotationProcessorsMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            AnnotationProcessorData annotationProcessorData = new AnnotationProcessorData((String)it.getKey(), (Duration)it.getValue());
            collection2.add(annotationProcessorData);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnnotationProcessorData> getNonIncrementalAnnotationProcessorsData() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.nonIncrementalAnnotationProcessorsSet;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Duration duration = this.annotationProcessorsMap.get(it);
            Intrinsics.checkNotNull((Object)duration);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"annotationProcessorsMap[it]!!");
            AnnotationProcessorData annotationProcessorData = new AnnotationProcessorData((String)it, duration);
            collection2.add(annotationProcessorData);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public BuildAttributionWarningsFilter getWarningsFilter() {
        return this.warningsFilter;
    }

    public AnnotationProcessorsAnalyzer(@NotNull BuildAttributionWarningsFilter warningsFilter) {
        Intrinsics.checkNotNullParameter((Object)warningsFilter, (String)"warningsFilter");
        this.warningsFilter = warningsFilter;
        this.annotationProcessorsMap = new HashMap();
        this.nonIncrementalAnnotationProcessorsSet = new HashSet();
    }
}

