/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import git4idea.fetch.GitRemoteOperationQueue;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/fetch/GitRemoteOperationQueueImpl;", "Lgit4idea/fetch/GitRemoteOperationQueue;", "()V", "busyRemotes", "", "Lgit4idea/fetch/GitRemoteOperationQueueImpl$RemoteCoordinates;", "kotlin.jvm.PlatformType", "", "executeForRemote", "T", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "operation", "Lkotlin/Function0;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "RemoteCoordinates", "intellij.vcs.git"})
public final class GitRemoteOperationQueueImpl
implements GitRemoteOperationQueue {
    private final Set<RemoteCoordinates> busyRemotes = Collections.newSetFromMap(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeForRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Function0<? extends T> operation) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        RemoteCoordinates remoteCoordinates = new RemoteCoordinates(repository, remote);
        while (true) {
            indicator.checkCanceled();
            if (this.busyRemotes.add(remoteCoordinates)) break;
            TimeoutUtil.sleep((long)50L);
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            this.busyRemotes.remove(remoteCoordinates);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lgit4idea/fetch/GitRemoteOperationQueueImpl$RemoteCoordinates;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;)V", "repositoryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lgit4idea/repo/GitRemote;)V", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepositoryRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class RemoteCoordinates {
        @NotNull
        private final VirtualFile repositoryRoot;
        @NotNull
        private final GitRemote remote;

        @NotNull
        public final VirtualFile getRepositoryRoot() {
            return this.repositoryRoot;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        public RemoteCoordinates(@NotNull VirtualFile repositoryRoot, @NotNull GitRemote remote) {
            Intrinsics.checkNotNullParameter((Object)repositoryRoot, (String)"repositoryRoot");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            this.repositoryRoot = repositoryRoot;
            this.remote = remote;
        }

        public RemoteCoordinates(@NotNull GitRepository repository, @NotNull GitRemote remote) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
            this(virtualFile, remote);
        }

        @NotNull
        public final VirtualFile component1() {
            return this.repositoryRoot;
        }

        @NotNull
        public final GitRemote component2() {
            return this.remote;
        }

        @NotNull
        public final RemoteCoordinates copy(@NotNull VirtualFile repositoryRoot, @NotNull GitRemote remote) {
            Intrinsics.checkNotNullParameter((Object)repositoryRoot, (String)"repositoryRoot");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            return new RemoteCoordinates(repositoryRoot, remote);
        }

        public static /* synthetic */ RemoteCoordinates copy$default(RemoteCoordinates remoteCoordinates, VirtualFile virtualFile, GitRemote gitRemote, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = remoteCoordinates.repositoryRoot;
            }
            if ((n & 2) != 0) {
                gitRemote = remoteCoordinates.remote;
            }
            return remoteCoordinates.copy(virtualFile, gitRemote);
        }

        @NotNull
        public String toString() {
            return "RemoteCoordinates(repositoryRoot=" + this.repositoryRoot + ", remote=" + this.remote + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.repositoryRoot;
            GitRemote gitRemote = this.remote;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (gitRemote != null ? ((Object)gitRemote).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RemoteCoordinates)) break block3;
                    RemoteCoordinates remoteCoordinates = (RemoteCoordinates)object;
                    if (!Intrinsics.areEqual((Object)this.repositoryRoot, (Object)remoteCoordinates.repositoryRoot) || !Intrinsics.areEqual((Object)this.remote, (Object)remoteCoordinates.remote)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

