/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef;

import com.jetbrains.cef.JCefVersionDetails;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.cef.CefSettings;
import org.cef.OS;

public abstract class JCefAppConfig {
    protected final CefSettings cefSettings = new CefSettings();
    protected final List<String> appArgs = new ArrayList<String>();

    public String[] getAppArgs() {
        return this.appArgs.toArray(new String[0]);
    }

    public List<String> getAppArgsAsList() {
        return this.appArgs;
    }

    public CefSettings getCefSettings() {
        return this.cefSettings;
    }

    public static JCefAppConfig getInstance() {
        if (Holder.INSTANCE == null) {
            throw new IllegalStateException("JCEF is not supported on this platform");
        }
        Holder.INSTANCE.init();
        return Holder.INSTANCE;
    }

    private static String getVersionEx() throws IOException {
        try (InputStream inputStream = JCefAppConfig.class.getResourceAsStream("version.info");){
            String string = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            return string;
        }
    }

    public static String getVersion() {
        try {
            return JCefAppConfig.getVersionEx();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JCefVersionDetails getVersionDetails() throws JCefVersionDetails.VersionUnavailableException {
        try {
            return new JCefVersionDetails(JCefAppConfig.getVersionEx());
        }
        catch (IOException e) {
            throw new JCefVersionDetails.VersionUnavailableException("Unable to load version information", e);
        }
    }

    protected abstract void init();

    private static double sysScale() {
        GraphicsConfiguration gc;
        GraphicsDevice device = null;
        double scale = 1.0;
        try {
            device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (device != null && (gc = device.getDefaultConfiguration()) != null) {
            scale = gc.getDefaultTransform().getScaleX();
        }
        return scale;
    }

    private static class JCefAppConfigLinux
    extends JCefAppConfig {
        private JCefAppConfigLinux() {
        }

        @Override
        protected void init() {
            String JCEF_PATH;
            this.cefSettings.resources_dir_path = JCEF_PATH = System.getProperty("java.home") + "/lib";
            this.cefSettings.locales_dir_path = JCEF_PATH + "/locales";
            this.cefSettings.browser_subprocess_path = JCEF_PATH + "/jcef_helper";
            double scale = JCefAppConfig.sysScale();
            System.setProperty("jcef.forceDeviceScaleFactor", Double.toString(scale));
            this.appArgs.add("--force-device-scale-factor=" + scale);
            this.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
        }
    }

    private static class JCefAppConfigWindows
    extends JCefAppConfig {
        private JCefAppConfigWindows() {
        }

        @Override
        protected void init() {
            String JCEF_PATH;
            this.cefSettings.resources_dir_path = JCEF_PATH = System.getProperty("java.home") + "/bin";
            this.cefSettings.locales_dir_path = JCEF_PATH + "/locales";
            this.cefSettings.browser_subprocess_path = JCEF_PATH + "/jcef_helper";
            this.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
        }
    }

    private static class JCefAppConfigMac
    extends JCefAppConfig {
        private JCefAppConfigMac() {
        }

        @Override
        protected void init() {
            String ALT_CEF_FRAMEWORK_DIR = System.getenv("ALT_CEF_FRAMEWORK_DIR");
            String ALT_CEF_HELPER_APP_DIR = System.getenv("ALT_CEF_HELPER_APP_DIR");
            if (ALT_CEF_FRAMEWORK_DIR == null || ALT_CEF_HELPER_APP_DIR == null) {
                String CONTENTS_PATH = System.getProperty("java.home") + "/..";
                if (ALT_CEF_FRAMEWORK_DIR == null) {
                    ALT_CEF_FRAMEWORK_DIR = CONTENTS_PATH + "/Frameworks/Chromium Embedded Framework.framework";
                }
                if (ALT_CEF_HELPER_APP_DIR == null) {
                    ALT_CEF_HELPER_APP_DIR = CONTENTS_PATH + "/Frameworks/jcef Helper.app";
                }
            }
            this.appArgs.add("--framework-dir-path=" + JCefAppConfigMac.normalize(ALT_CEF_FRAMEWORK_DIR));
            this.appArgs.add("--browser-subprocess-path=" + JCefAppConfigMac.normalize(ALT_CEF_HELPER_APP_DIR + "/Contents/MacOS/jcef Helper"));
            this.appArgs.add("--main-bundle-path=" + JCefAppConfigMac.normalize(ALT_CEF_HELPER_APP_DIR));
            this.appArgs.add("--disable-in-process-stack-traces");
            this.appArgs.add("--use-mock-keychain");
            this.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
        }

        static String normalize(String path) {
            try {
                return new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Holder {
        static JCefAppConfig INSTANCE;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Holder() {
        }

        static {
            boolean bl = $assertionsDisabled = !JCefAppConfig.class.desiredAssertionStatus();
            if (OS.isMacintosh()) {
                INSTANCE = new JCefAppConfigMac();
            } else if (OS.isLinux()) {
                INSTANCE = new JCefAppConfigLinux();
            } else if (OS.isWindows()) {
                INSTANCE = new JCefAppConfigWindows();
            } else {
                INSTANCE = null;
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"JCEF: unknown platform");
                }
            }
        }
    }
}

