/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.DefaultExecSpec;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.ProcessStreamsSpec;

public class DefaultJavaExecSpec
extends DefaultJavaForkOptions
implements JavaExecSpec,
ProcessArgumentsSpec.HasExecutable {
    private boolean ignoreExitValue;
    private final ProcessStreamsSpec streamsSpec = new ProcessStreamsSpec();
    private final ProcessArgumentsSpec argumentsSpec = new ProcessArgumentsSpec(this);
    private final Property<String> mainClass;
    private final Property<String> mainModule;
    private final ModularitySpec modularity;
    private final FileCollectionFactory fileCollectionFactory;
    private ConfigurableFileCollection classpath;

    @Inject
    public DefaultJavaExecSpec(ObjectFactory objectFactory, PathToFileResolver resolver, FileCollectionFactory fileCollectionFactory) {
        super(resolver, fileCollectionFactory, objectFactory.newInstance(DefaultJavaDebugOptions.class, new Object[0]));
        this.mainClass = objectFactory.property(String.class);
        this.mainModule = objectFactory.property(String.class);
        this.modularity = objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.fileCollectionFactory = fileCollectionFactory;
        this.classpath = fileCollectionFactory.configurableFiles("classpath");
    }

    public void copyTo(JavaExecSpec targetSpec) {
        targetSpec.setArgs(this.getArgs());
        targetSpec.getArgumentProviders().addAll(this.getArgumentProviders());
        targetSpec.getMainClass().set(this.getMainClass());
        targetSpec.getMainModule().set(this.getMainModule());
        targetSpec.getModularity().getInferModulePath().set(this.getModularity().getInferModulePath());
        targetSpec.classpath(this.getClasspath());
        DefaultExecSpec.copyBaseExecSpecTo(this, targetSpec);
        super.copyTo(targetSpec);
    }

    @Override
    public List<String> getCommandLine() {
        return this.argumentsSpec.getCommandLine();
    }

    @Override
    public JavaExecSpec args(Object ... args) {
        this.argumentsSpec.args(args);
        return this;
    }

    @Override
    public JavaExecSpec args(Iterable<?> args) {
        this.argumentsSpec.args(args);
        return this;
    }

    @Override
    public JavaExecSpec setArgs(@Nullable List<String> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    @Override
    public JavaExecSpec setArgs(@Nullable Iterable<?> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    @Override
    @Nullable
    public List<String> getArgs() {
        return this.argumentsSpec.getArgs();
    }

    @Override
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentsSpec.getArgumentProviders();
    }

    @Override
    public JavaExecSpec classpath(Object ... paths) {
        this.classpath.from(paths);
        return this;
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public JavaExecSpec setClasspath(FileCollection classpath) {
        this.classpath = this.fileCollectionFactory.configurableFiles("classpath");
        this.classpath.setFrom(classpath);
        return this;
    }

    @Override
    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    @Override
    public JavaExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    @Override
    public InputStream getStandardInput() {
        return this.streamsSpec.getStandardInput();
    }

    @Override
    public JavaExecSpec setStandardInput(InputStream standardInput) {
        this.streamsSpec.setStandardInput(standardInput);
        return this;
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.streamsSpec.getStandardOutput();
    }

    @Override
    public JavaExecSpec setStandardOutput(OutputStream standardOutput) {
        this.streamsSpec.setStandardOutput(standardOutput);
        return this;
    }

    @Override
    public OutputStream getErrorOutput() {
        return this.streamsSpec.getErrorOutput();
    }

    @Override
    public JavaExecSpec setErrorOutput(OutputStream errorOutput) {
        this.streamsSpec.setErrorOutput(errorOutput);
        return this;
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    @Nullable
    public String getMain() {
        return (String)this.mainClass.getOrNull();
    }

    @Override
    public JavaExecSpec setMain(@Nullable String main) {
        this.mainClass.set(main);
        return this;
    }

    @Override
    public Property<String> getMainModule() {
        return this.mainModule;
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }
}

