/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.internal.model.InstantiatorBackedObjectFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.process.JavaDebugOptions;

public class DefaultJavaDebugOptions
implements JavaDebugOptions {
    private final Property<Boolean> enabled;
    private final Property<Integer> port;
    private final Property<Boolean> server;
    private final Property<Boolean> suspend;

    @Inject
    public DefaultJavaDebugOptions(ObjectFactory objectFactory) {
        this.enabled = objectFactory.property(Boolean.class).convention(false);
        this.port = objectFactory.property(Integer.class).convention(5005);
        this.server = objectFactory.property(Boolean.class).convention(true);
        this.suspend = objectFactory.property(Boolean.class).convention(true);
    }

    public DefaultJavaDebugOptions() {
        this(new InstantiatorBackedObjectFactory(DirectInstantiator.INSTANCE));
    }

    public int hashCode() {
        return Objects.hash(this.getEnabled().get(), this.getPort().get(), this.getServer().get(), this.getSuspend().get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJavaDebugOptions that = (DefaultJavaDebugOptions)o;
        return this.enabled.get() == that.enabled.get() && ((Integer)this.port.get()).equals(that.port.get()) && this.server.get() == that.server.get() && this.suspend.get() == that.suspend.get();
    }

    @Override
    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    public Property<Integer> getPort() {
        return this.port;
    }

    @Override
    public Property<Boolean> getServer() {
        return this.server;
    }

    @Override
    public Property<Boolean> getSuspend() {
        return this.suspend;
    }
}

