/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.envjs.browser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.plugins.javascript.envjs.browser.BrowserEvaluator;
import org.gradle.plugins.javascript.envjs.http.HttpFileServer;
import org.gradle.plugins.javascript.envjs.http.simple.SimpleHttpFileServerFactory;

public class BrowserEvaluate
extends DefaultTask {
    private Object content;
    private Object resource;
    private BrowserEvaluator evaluator;
    private Object result;

    public BrowserEvaluate() {
        this.dependsOn(new Callable<TaskDependency>(){

            @Override
            public TaskDependency call() throws Exception {
                return BrowserEvaluate.this.getProject().files(BrowserEvaluate.this.content).getBuildDependencies();
            }
        });
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public File getContent() {
        return this.content == null ? null : this.getProject().files(this.content).getSingleFile();
    }

    public void setContent(File content) {
        this.content = content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    @Input
    public String getResource() {
        return this.resource.toString();
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setResource(Object resource) {
        this.resource = resource;
    }

    @Internal
    public BrowserEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(BrowserEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @OutputFile
    public File getResult() {
        return this.result == null ? null : this.getProject().file(this.result);
    }

    public void setResult(File result) {
        this.result = result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    @TaskAction
    void doEvaluate() {
        HttpFileServer fileServer = new SimpleHttpFileServerFactory().start(this.getContent(), 0);
        try {
            FileWriter resultWriter = new FileWriter(this.getResult());
            this.getEvaluator().evaluate(fileServer.getResourceUrl(this.getResource()), resultWriter);
            ((Writer)resultWriter).close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            fileServer.stop();
        }
        this.setDidWork(true);
    }
}

