/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.RestrictiveCodeVisitor;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.model.dsl.internal.transform.RuleVisitor;
import org.gradle.model.dsl.internal.transform.RulesBlock;
import org.gradle.model.internal.core.ModelPath;

public class RulesVisitor
extends RestrictiveCodeVisitor {
    private static final String AST_NODE_METADATA_KEY = RulesVisitor.class.getName();
    private static final ClassNode ANNOTATION_CLASS_NODE = new ClassNode(RulesBlock.class);
    public static final String INVALID_STATEMENT = "illegal rule";
    public static final String INVALID_RULE_SIGNATURE = "Rule must follow the pattern '\u00abname\u00bb(\u00abtype\u00bb) {}' for a registration, and '\u00abname\u00bb {}' for an action";
    private final RuleVisitor ruleVisitor;

    public RulesVisitor(SourceUnit sourceUnit, RuleVisitor ruleVisitor) {
        super(sourceUnit, INVALID_STATEMENT);
        this.ruleVisitor = ruleVisitor;
    }

    public static void visitGeneratedClosure(ClassNode node) {
        MethodNode method = AstUtils.getGeneratedClosureImplMethod(node);
        Boolean isRulesBlock = (Boolean)method.getCode().getNodeMetaData((Object)AST_NODE_METADATA_KEY);
        if (isRulesBlock != null) {
            AnnotationNode markerAnnotation = new AnnotationNode(ANNOTATION_CLASS_NODE);
            node.addAnnotation(markerAnnotation);
        }
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        block.setNodeMetaData((Object)AST_NODE_METADATA_KEY, (Object)true);
        for (Statement statement : block.getStatements()) {
            statement.visit((GroovyCodeVisitor)this);
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        statement.getExpression().visit((GroovyCodeVisitor)this);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        ClosureExpression closureExpression = AstUtils.getSingleClosureArg((MethodCall)call);
        if (closureExpression != null) {
            this.rewriteAction(call, this.extractModelPathFromMethodTarget(call), closureExpression, RuleVisitor.displayName(call));
            return;
        }
        Pair<ClassExpression, ClosureExpression> args = AstUtils.getClassAndClosureArgs((MethodCall)call);
        if (args != null) {
            this.rewriteCreator(call, this.extractModelPathFromMethodTarget(call), args.getRight(), args.getLeft(), RuleVisitor.displayName(call));
            return;
        }
        ClassExpression classArg = AstUtils.getClassArg((MethodCall)call);
        if (classArg != null) {
            String displayName = RuleVisitor.displayName(call);
            LinkedList statements = Lists.newLinkedList();
            statements.add(new EmptyStatement());
            BlockStatement block = new BlockStatement((List)statements, new VariableScope());
            closureExpression = new ClosureExpression(Parameter.EMPTY_ARRAY, (Statement)block);
            closureExpression.setVariableScope(block.getVariableScope());
            String modelPath = this.extractModelPathFromMethodTarget(call);
            this.rewriteCreator(call, modelPath, closureExpression, classArg, displayName);
            return;
        }
        this.restrict((ASTNode)call, INVALID_RULE_SIGNATURE);
    }

    public void rewriteCreator(MethodCallExpression call, String modelPath, ClosureExpression closureExpression, ClassExpression typeExpression, String displayName) {
        ConstantExpression modelPathArgument = new ConstantExpression((Object)modelPath);
        ArgumentListExpression replacedArgumentList = new ArgumentListExpression((Expression)modelPathArgument, (Expression)typeExpression, (Expression)closureExpression);
        call.setMethod((Expression)new ConstantExpression((Object)"create"));
        call.setArguments((Expression)replacedArgumentList);
        call.setImplicitThis(true);
        call.setObjectExpression((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "getDelegate", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        this.ruleVisitor.visitRuleClosure(closureExpression, (Expression)call, displayName);
    }

    public void rewriteAction(MethodCallExpression call, String modelPath, ClosureExpression closureExpression, String displayName) {
        ConstantExpression modelPathArgument = new ConstantExpression((Object)modelPath);
        ArgumentListExpression replacedArgumentList = new ArgumentListExpression((Expression)modelPathArgument, (Expression)closureExpression);
        call.setMethod((Expression)new ConstantExpression((Object)"configure"));
        call.setArguments((Expression)replacedArgumentList);
        call.setImplicitThis(true);
        call.setObjectExpression((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "getDelegate", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        this.ruleVisitor.visitRuleClosure(closureExpression, (Expression)call, displayName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private String extractModelPathFromMethodTarget(MethodCallExpression call) {
        block7: {
            Expression target = call.getMethod();
            LinkedList names = Lists.newLinkedList();
            while (true) {
                if (target instanceof ConstantExpression) {
                    if (target.getType().equals((Object)ClassHelper.STRING_TYPE)) {
                        String name = target.getText();
                        names.add(0, name);
                        if (call.isImplicitThis()) {
                            return ModelPath.pathString((String[])Iterables.toArray((Iterable)names, String.class));
                        }
                        target = call.getObjectExpression();
                        continue;
                    }
                } else {
                    ConstantExpression constantProperty;
                    if (!(target instanceof PropertyExpression)) break;
                    PropertyExpression propertyExpression = (PropertyExpression)target;
                    Expression property = propertyExpression.getProperty();
                    if (property instanceof ConstantExpression && (constantProperty = (ConstantExpression)property).getType().equals((Object)ClassHelper.STRING_TYPE)) {
                        String name = constantProperty.getText();
                        names.add(0, name);
                        target = propertyExpression.getObjectExpression();
                        continue;
                    }
                }
                break block7;
                break;
            }
            if (target instanceof VariableExpression) {
                names.add(0, ((VariableExpression)target).getName());
                return ModelPath.pathString((String[])Iterables.toArray((Iterable)names, String.class));
            }
        }
        this.restrict((ASTNode)call);
        return null;
    }
}

