/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.SimpleExpression;

public abstract class AbstractExpression
implements Expression {
    public String toString() {
        return this.getAsSourceText();
    }

    @Override
    public String getAsSourceText() {
        return AbstractExpression.format(this);
    }

    @Override
    public List<Expression> getArguments() {
        return Collections.emptyList();
    }

    @Override
    public Expression asMacroExpansion() {
        return AbstractExpression.asMacroExpansion(this);
    }

    static Expression asMacroExpansion(Expression expression) {
        if (expression.getType() == IncludeType.IDENTIFIER) {
            return new SimpleExpression(expression.getValue(), IncludeType.MACRO);
        }
        if (expression.getType() == IncludeType.TOKEN_CONCATENATION) {
            return new ComplexExpression(IncludeType.EXPAND_TOKEN_CONCATENATION, expression.getValue(), expression.getArguments());
        }
        if (expression.getType() == IncludeType.ARGS_LIST && !expression.getArguments().isEmpty()) {
            ArrayList<Expression> mapped = new ArrayList<Expression>(expression.getArguments().size());
            for (Expression arg : expression.getArguments()) {
                mapped.add(arg.asMacroExpansion());
            }
            return new ComplexExpression(IncludeType.ARGS_LIST, null, mapped);
        }
        return expression;
    }

    static String format(Expression expression) {
        return AbstractExpression.format(expression.getType(), expression.getValue(), expression.getArguments());
    }

    static String format(IncludeType type, @Nullable String value, List<Expression> arguments) {
        switch (type) {
            case QUOTED: {
                return '\"' + value + '\"';
            }
            case SYSTEM: {
                return '<' + value + '>';
            }
            case MACRO: 
            case IDENTIFIER: 
            case TOKEN: {
                return value;
            }
            case TOKEN_CONCATENATION: 
            case EXPAND_TOKEN_CONCATENATION: {
                return arguments.get(0).getAsSourceText() + "##" + arguments.get(1).getAsSourceText();
            }
            case MACRO_FUNCTION: {
                return value + "(" + Joiner.on((String)", ").join(arguments) + ")";
            }
            case EXPRESSIONS: {
                return Joiner.on((String)" ").join(arguments);
            }
            case ARGS_LIST: {
                return "(" + Joiner.on((String)", ").join(arguments) + ")";
            }
        }
        return value != null ? value : "??";
    }
}

