/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.BuildableCompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CollectingMacroLookup;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.DefaultIncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileEdge;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileSourceProcessor;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCompileFilesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalCompileFilesFactory.class);
    private static final String IGNORE_UNRESOLVED_HEADERS_IN_DEPENDENCIES_PROPERTY_NAME = "org.gradle.internal.native.headers.unresolved.dependencies.ignore";
    private final IncludeDirectives initialIncludeDirectives;
    private final SourceIncludesParser sourceIncludesParser;
    private final SourceIncludesResolver sourceIncludesResolver;
    private final FileSystemAccess fileSystemAccess;
    private final boolean ignoreUnresolvedHeadersInDependencies;

    public IncrementalCompileFilesFactory(IncludeDirectives initialIncludeDirectives, SourceIncludesParser sourceIncludesParser, SourceIncludesResolver sourceIncludesResolver, FileSystemAccess fileSystemAccess) {
        this.initialIncludeDirectives = initialIncludeDirectives;
        this.sourceIncludesParser = sourceIncludesParser;
        this.sourceIncludesResolver = sourceIncludesResolver;
        this.fileSystemAccess = fileSystemAccess;
        this.ignoreUnresolvedHeadersInDependencies = Boolean.getBoolean(IGNORE_UNRESOLVED_HEADERS_IN_DEPENDENCIES_PROPERTY_NAME);
    }

    public IncrementalCompileSourceProcessor files(CompilationState previousCompileState) {
        return new DefaultIncrementalCompileSourceProcessor(previousCompileState);
    }

    private static class FileVisitResult
    implements CollectingMacroLookup.MacroSource {
        private final File file;
        private final IncludeFileResolutionResult result;
        private final IncludeDirectives includeDirectives;
        private final List<FileVisitResult> included;
        private final List<IncludeFileEdge> edges;
        private final CollectingMacroLookup includeFileDirectives;

        FileVisitResult(File file, IncludeFileResolutionResult result, IncludeDirectives includeDirectives, List<FileVisitResult> included, List<IncludeFileEdge> edges, CollectingMacroLookup dependentIncludeDirectives) {
            this.file = file;
            this.result = result;
            this.includeDirectives = includeDirectives;
            this.included = included;
            this.edges = edges;
            this.includeFileDirectives = dependentIncludeDirectives;
        }

        FileVisitResult(File file) {
            this.file = file;
            this.result = IncludeFileResolutionResult.NoMacroIncludes;
            this.includeDirectives = null;
            this.included = Collections.emptyList();
            this.edges = Collections.emptyList();
            this.includeFileDirectives = null;
        }

        void collectDependencies(CollectingMacroLookup directives) {
            if (this.includeDirectives != null) {
                directives.append(this);
            }
        }

        void collectFilesInto(Collection<IncludeFileEdge> files2, Set<File> seen) {
            if (this.includeDirectives != null && seen.add(this.file)) {
                files2.addAll(this.edges);
                for (FileVisitResult include : this.included) {
                    include.collectFilesInto(files2, seen);
                }
            }
        }

        @Override
        public void collectInto(CollectingMacroLookup lookup) {
            if (this.includeDirectives != null) {
                lookup.append(this.file, this.includeDirectives);
                this.includeFileDirectives.appendTo(lookup);
            }
        }
    }

    private static class FileDetails {
        final IncludeDirectives directives;
        @Nullable
        FileVisitResult results;

        FileDetails(IncludeDirectives directives) {
            this.directives = directives;
        }
    }

    private static enum IncludeFileResolutionResult {
        NoMacroIncludes,
        HasMacroIncludes,
        UnresolvedMacroIncludes;

    }

    private class DefaultIncrementalCompileSourceProcessor
    implements IncrementalCompileSourceProcessor {
        private final CompilationState previous;
        private final BuildableCompilationState current = new BuildableCompilationState();
        private final List<File> toRecompile = new ArrayList<File>();
        private final Set<File> existingHeaders = new HashSet<File>();
        private final Map<File, FileDetails> visitedFiles = new HashMap<File, FileDetails>();
        private boolean hasUnresolvedHeaders;

        DefaultIncrementalCompileSourceProcessor(CompilationState previousCompileState) {
            this.previous = previousCompileState == null ? new CompilationState() : previousCompileState;
        }

        @Override
        public IncrementalCompilation getResult() {
            return new DefaultIncrementalCompilation(this.current.snapshot(), this.toRecompile, this.getRemovedSources(), this.existingHeaders, this.hasUnresolvedHeaders);
        }

        @Override
        public void processSource(File sourceFile) {
            if (this.visitSourceFile(sourceFile)) {
                this.toRecompile.add(sourceFile);
            }
        }

        private boolean visitSourceFile(File sourceFile) {
            return IncrementalCompileFilesFactory.this.fileSystemAccess.readRegularFileContentHash(sourceFile.getAbsolutePath(), fileContent -> {
                SourceFileState previousState = this.previous.getState(sourceFile);
                if (previousState != null && this.graphHasNotChanged(sourceFile, (HashCode)fileContent, previousState, this.existingHeaders)) {
                    this.current.setState(sourceFile, previousState);
                    if (previousState.isHasUnresolved() && !IncrementalCompileFilesFactory.this.ignoreUnresolvedHeadersInDependencies) {
                        this.hasUnresolvedHeaders = true;
                        return true;
                    }
                    return false;
                }
                CollectingMacroLookup visibleMacros = new CollectingMacroLookup(IncrementalCompileFilesFactory.this.initialIncludeDirectives);
                FileVisitResult result = this.visitFile(sourceFile, (HashCode)fileContent, visibleMacros, (Set<HashCode>)new HashSet<HashCode>(), this.existingHeaders);
                LinkedHashSet<IncludeFileEdge> includedFiles = new LinkedHashSet<IncludeFileEdge>();
                result.collectFilesInto(includedFiles, new HashSet<File>());
                SourceFileState newState = new SourceFileState((HashCode)fileContent, result.result == IncludeFileResolutionResult.UnresolvedMacroIncludes, (ImmutableSet<IncludeFileEdge>)ImmutableSet.copyOf(includedFiles));
                this.current.setState(sourceFile, newState);
                if (newState.isHasUnresolved()) {
                    this.hasUnresolvedHeaders = true;
                }
                return true;
            }).orElse(false);
        }

        private boolean graphHasNotChanged(File sourceFile, HashCode fileHash, SourceFileState previousState, Set<File> existingHeaders) {
            if (!fileHash.equals(previousState.getHash())) {
                return false;
            }
            if (previousState.getEdges().isEmpty()) {
                return true;
            }
            HashMap<HashCode, File> includes = new HashMap<HashCode, File>(previousState.getEdges().size());
            HashSet<File> headers = new HashSet<File>();
            includes.put(fileHash, sourceFile);
            for (IncludeFileEdge includeFileEdge : previousState.getEdges()) {
                File includedFrom = includeFileEdge.getIncludedBy() != null ? (File)includes.get(includeFileEdge.getIncludedBy()) : null;
                SourceIncludesResolver.IncludeFile includeFile = IncrementalCompileFilesFactory.this.sourceIncludesResolver.resolveInclude(includedFrom, includeFileEdge.getIncludePath());
                if (includeFile == null) {
                    return false;
                }
                HashCode hash = includeFile.getContentHash();
                if (!hash.equals(includeFileEdge.getResolvedTo())) {
                    return false;
                }
                if (!existingHeaders.contains(includeFile.getFile())) {
                    headers.add(includeFile.getFile());
                }
                includes.put(hash, includeFile.getFile());
            }
            existingHeaders.addAll(headers);
            return true;
        }

        private FileVisitResult visitFile(File file, HashCode newHash, CollectingMacroLookup visibleMacros, Set<HashCode> visited, Set<File> existingHeaders) {
            FileDetails fileDetails = this.visitedFiles.get(file);
            if (fileDetails != null && fileDetails.results != null) {
                visibleMacros.append(fileDetails.results);
                return fileDetails.results;
            }
            if (!visited.add(newHash)) {
                return new FileVisitResult(file);
            }
            if (fileDetails == null) {
                IncludeDirectives includeDirectives = IncrementalCompileFilesFactory.this.sourceIncludesParser.parseIncludes(file);
                fileDetails = new FileDetails(includeDirectives);
                this.visitedFiles.put(file, fileDetails);
            }
            CollectingMacroLookup includedFileDirectives = new CollectingMacroLookup();
            visibleMacros.append(file, fileDetails.directives);
            List<Include> allIncludes = fileDetails.directives.getAll();
            ArrayList<FileVisitResult> included = allIncludes.isEmpty() ? Collections.emptyList() : new ArrayList<FileVisitResult>(allIncludes.size());
            ArrayList<IncludeFileEdge> edges = allIncludes.isEmpty() ? Collections.emptyList() : new ArrayList<IncludeFileEdge>(allIncludes.size());
            IncludeFileResolutionResult result = IncludeFileResolutionResult.NoMacroIncludes;
            for (Include include : allIncludes) {
                SourceIncludesResolver.IncludeResolutionResult resolutionResult;
                if (include.getType() == IncludeType.MACRO && result == IncludeFileResolutionResult.NoMacroIncludes) {
                    result = IncludeFileResolutionResult.HasMacroIncludes;
                }
                if (!(resolutionResult = IncrementalCompileFilesFactory.this.sourceIncludesResolver.resolveInclude(file, include, visibleMacros)).isComplete()) {
                    LOGGER.info("Cannot locate header file for '{}' in source file '{}'. Assuming changed.", (Object)include.getAsSourceText(), (Object)file.getName());
                    if (!IncrementalCompileFilesFactory.this.ignoreUnresolvedHeadersInDependencies) {
                        result = IncludeFileResolutionResult.UnresolvedMacroIncludes;
                    }
                }
                for (SourceIncludesResolver.IncludeFile includeFile : resolutionResult.getFiles()) {
                    existingHeaders.add(includeFile.getFile());
                    FileVisitResult includeVisitResult = this.visitFile(includeFile.getFile(), includeFile.getContentHash(), visibleMacros, visited, existingHeaders);
                    if (includeVisitResult.result.ordinal() > result.ordinal()) {
                        result = includeVisitResult.result;
                    }
                    includeVisitResult.collectDependencies(includedFileDirectives);
                    included.add(includeVisitResult);
                    edges.add(new IncludeFileEdge(includeFile.getPath(), includeFile.isQuotedInclude() ? newHash : null, includeFile.getContentHash()));
                }
            }
            FileVisitResult visitResult = new FileVisitResult(file, result, fileDetails.directives, included, edges, includedFileDirectives);
            if (result == IncludeFileResolutionResult.NoMacroIncludes) {
                fileDetails.results = visitResult;
            }
            return visitResult;
        }

        private List<File> getRemovedSources() {
            ArrayList<File> removed = new ArrayList<File>();
            for (File previousSource : this.previous.getSourceInputs()) {
                if (this.current.getSourceInputs().contains(previousSource)) continue;
                removed.add(previousSource);
            }
            return removed;
        }
    }
}

