/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.resolve.VariantBinarySelector;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.jvm.internal.resolve.VariantAxisCompatibilityFactory;
import org.gradle.jvm.internal.resolve.VariantsMatcher;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.Binary;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.VariantComponent;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class JvmVariantSelector
implements VariantBinarySelector {
    private final VariantsMatcher variantsMatcher;
    private final VariantsMetaData variantsMetaData;

    public JvmVariantSelector(List<VariantAxisCompatibilityFactory> factories, Class<? extends BinarySpec> binarySpecType, ModelSchemaStore schemaStore, VariantsMetaData variantsMetaData) {
        this.variantsMatcher = new VariantsMatcher(factories, binarySpecType, schemaStore);
        this.variantsMetaData = variantsMetaData;
    }

    public Collection<? extends BinarySpec> selectVariants(VariantComponent componentSpec, @Nullable String requestedVariant) {
        ArrayList allBinaries = Lists.newArrayList();
        for (Binary binary : componentSpec.getVariants()) {
            allBinaries.add((BinarySpec)binary);
        }
        if (requestedVariant != null) {
            for (Binary binary : allBinaries) {
                BinarySpecInternal binary2 = (BinarySpecInternal)binary;
                LibraryBinaryIdentifier id = binary2.getId();
                if (!Objects.equal((Object)requestedVariant, (Object)id.getVariant())) continue;
                return Collections.singleton(binary2);
            }
            return Collections.emptySet();
        }
        return this.variantsMatcher.filterBinaries(this.variantsMetaData, allBinaries);
    }
}

