/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.resolve;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.jvm.internal.resolve.DefaultVariantsMetaData;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.jvm.internal.resolve.VariantsMetaDataHelper;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.Binary;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.util.TextUtil;

public class DefaultLibraryResolutionErrorMessageBuilder
implements LibraryResolutionErrorMessageBuilder {
    private static final String TARGET_PLATFORM = "targetPlatform";
    private final VariantsMetaData variantsMetaData;
    private final ModelSchemaStore schemaStore;
    private final Set<String> variantAxesToResolve;

    public DefaultLibraryResolutionErrorMessageBuilder(VariantsMetaData variantsMetaData, ModelSchemaStore schemaStore) {
        this.variantsMetaData = variantsMetaData;
        this.schemaStore = schemaStore;
        this.variantAxesToResolve = variantsMetaData.getNonNullVariantAxes();
    }

    @Override
    public String multipleCompatibleVariantsErrorMessage(String libraryName, Iterable<? extends Binary> binaries) {
        ArrayList<String> variantDescriptors = new ArrayList<String>();
        StringBuilder variantDescriptor = new StringBuilder();
        for (Binary binary : binaries) {
            BinarySpec variant = (BinarySpec)binary;
            variantDescriptor.setLength(0);
            boolean first = true;
            variantDescriptor.append("    - ").append(variant.getDisplayName()).append(" [");
            VariantsMetaData metaData = DefaultVariantsMetaData.extractFrom(variant, this.schemaStore.getSchema(((BinarySpecInternal)variant).getPublicType()));
            for (String axis : metaData.getNonNullVariantAxes()) {
                if (first) {
                    first = false;
                } else {
                    variantDescriptor.append(", ");
                }
                variantDescriptor.append(this.renderAxisName(axis)).append(":'").append(metaData.getValueAsString(axis)).append("'");
            }
            variantDescriptor.append(TextUtil.toPlatformLineSeparators("]\n"));
            variantDescriptors.add(variantDescriptor.toString());
        }
        StringBuilder sb = new StringBuilder(String.format(TextUtil.toPlatformLineSeparators("Multiple compatible variants found for library '%s':\n"), libraryName));
        for (String descriptor : variantDescriptors) {
            sb.append(descriptor);
        }
        return sb.toString();
    }

    @Override
    public String noCompatibleVariantErrorMessage(String libraryName, Iterable<? extends Binary> allBinaries) {
        HashMultimap variantAxisMessages = HashMultimap.create();
        for (Binary binary : allBinaries) {
            BinarySpec spec = (BinarySpec)binary;
            VariantsMetaData md = DefaultVariantsMetaData.extractFrom(spec, this.schemaStore.getSchema(((BinarySpecInternal)spec).getPublicType()));
            Set<String> variantAxesWithIncompatibleTypes = VariantsMetaDataHelper.determineAxesWithIncompatibleTypes(this.variantsMetaData, md, this.variantAxesToResolve);
            for (String variantAxis : this.variantAxesToResolve) {
                String value = md.getValueAsString(variantAxis);
                if (value == null) continue;
                String message2 = String.format("'%s'", value);
                if (variantAxesWithIncompatibleTypes.contains(variantAxis)) {
                    message2 = String.format("%s but with an incompatible type (expected '%s' was '%s')", message2, this.variantsMetaData.getVariantAxisType(variantAxis).getConcreteClass().getName(), md.getVariantAxisType(variantAxis).getConcreteClass().getName());
                }
                variantAxisMessages.put((Object)variantAxis, (Object)message2);
            }
        }
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        StringBuilder stringBuilder = new StringBuilder(String.format(TextUtil.toPlatformLineSeparators("Cannot find a compatible variant for library '%s'.\n"), libraryName));
        for (String variantAxis : this.variantAxesToResolve) {
            String axisName = this.renderAxisName(variantAxis);
            stringBuilder.append("    Required ").append(axisName).append(" '").append(this.variantsMetaData.getValueAsString(variantAxis)).append("'");
            TreeSet available = new TreeSet(variantAxisMessages.get((Object)variantAxis));
            if (!available.isEmpty()) {
                stringBuilder.append(", available: ").append(joiner.join(available)).append("\n");
                continue;
            }
            stringBuilder.append(" but no compatible variant was found\n");
        }
        return stringBuilder.toString();
    }

    private String renderAxisName(String variantAxis) {
        return TARGET_PLATFORM.equals(variantAxis) ? "platform" : variantAxis;
    }
}

