/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.operations.trace.SerializedOperation;

class SerializedOperationFinish
implements SerializedOperation {
    final long id;
    final long endTime;
    final Object result;
    final String resultClassName;
    final String failureMsg;

    SerializedOperationFinish(BuildOperationDescriptor descriptor, OperationFinishEvent finishEvent) {
        this.id = descriptor.getId().getId();
        this.endTime = finishEvent.getEndTime();
        this.result = BuildOperationTrace.toSerializableModel(finishEvent.getResult());
        this.resultClassName = this.result == null ? null : finishEvent.getResult().getClass().getName();
        this.failureMsg = finishEvent.getFailure() == null ? null : finishEvent.getFailure().toString();
    }

    SerializedOperationFinish(Map<String, ?> map2) {
        this.id = ((Integer)map2.get("id")).longValue();
        this.endTime = (Long)map2.get("endTime");
        this.result = map2.get("result");
        this.resultClassName = (String)map2.get("resultClassName");
        this.failureMsg = (String)map2.get("failure");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        map2.put((Object)"id", (Object)this.id);
        if (this.result != null) {
            map2.put((Object)"result", this.result);
            map2.put((Object)"resultClassName", (Object)this.resultClassName);
        }
        if (this.failureMsg != null) {
            map2.put((Object)"failure", (Object)this.failureMsg);
        }
        map2.put((Object)"endTime", (Object)this.endTime);
        return map2.build();
    }
}

