/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.internal.concurrent.GradleThread;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationState;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmanagedBuildOperationWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnmanagedBuildOperationWrapper.class);
    private final BuildOperationListener listener;
    private final Clock clock;
    private final CurrentBuildOperationRef currentBuildOperationRef;

    public UnmanagedBuildOperationWrapper(BuildOperationListener listener, Clock clock, CurrentBuildOperationRef currentBuildOperationRef) {
        this.listener = listener;
        this.clock = clock;
        this.currentBuildOperationRef = currentBuildOperationRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithUnmanagedSupport(@Nullable BuildOperationState defaultParent, Consumer<BuildOperationState> work) {
        BuildOperationState parent = this.maybeStartUnmanagedThreadOperation(defaultParent);
        try {
            work.accept(parent);
        }
        finally {
            this.maybeStopUnmanagedThreadOperation(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T callWithUnmanagedSupport(@Nullable BuildOperationState defaultParent, Function<BuildOperationState, T> work) {
        BuildOperationState parent = this.maybeStartUnmanagedThreadOperation(defaultParent);
        try {
            T t = work.apply(parent);
            return t;
        }
        finally {
            this.maybeStopUnmanagedThreadOperation(parent);
        }
    }

    @Nullable
    private BuildOperationState maybeStartUnmanagedThreadOperation(@Nullable BuildOperationState parent) {
        if (parent == null && !GradleThread.isManaged()) {
            UnmanagedThreadOperation unmanaged = UnmanagedThreadOperation.create(this.clock.getCurrentTime());
            unmanaged.setRunning(true);
            this.currentBuildOperationRef.set(unmanaged);
            this.listener.started(unmanaged.getDescription(), new OperationStartEvent(unmanaged.getStartTime()));
            return unmanaged;
        }
        return parent;
    }

    private void maybeStopUnmanagedThreadOperation(@Nullable BuildOperationState current) {
        if (current instanceof UnmanagedThreadOperation) {
            try {
                this.listener.finished(current.getDescription(), new OperationFinishEvent(current.getStartTime(), this.clock.getCurrentTime(), null, null));
            }
            finally {
                this.currentBuildOperationRef.set(null);
                current.setRunning(false);
            }
        }
    }

    private static class UnmanagedThreadOperation
    extends BuildOperationState {
        private static final AtomicLong UNMANAGED_THREAD_OPERATION_COUNTER = new AtomicLong(-1L);

        private static UnmanagedThreadOperation create(long currentTime) {
            LOGGER.debug("WARNING No operation is currently running in unmanaged thread: {}", (Object)Thread.currentThread().getName());
            OperationIdentifier id = new OperationIdentifier(UNMANAGED_THREAD_OPERATION_COUNTER.getAndDecrement());
            String displayName = "Unmanaged thread operation #" + id + " (" + Thread.currentThread().getName() + ')';
            return new UnmanagedThreadOperation(BuildOperationDescriptor.displayName(displayName).build(id, null), currentTime);
        }

        private UnmanagedThreadOperation(BuildOperationDescriptor descriptor, long startTime) {
            super(descriptor, startTime);
        }
    }
}

