/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AdditionalVariant;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class RealisedMavenModuleResolveMetadata
extends AbstractRealisedModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    private final NamedObjectInstantiator objectInstantiator;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private final ImmutableList<? extends ConfigurationMetadata> derivedVariants;

    public static RealisedMavenModuleResolveMetadata transform(DefaultMavenModuleResolveMetadata metadata) {
        Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants;
        VariantMetadataRules variantMetadataRules = metadata.getVariantMetadataRules();
        ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> variants = LazyToRealisedModuleComponentResolveMetadataHelper.realiseVariants(metadata, variantMetadataRules, (ImmutableList<? extends ComponentVariant>)metadata.getVariants());
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)metadata.getConfigurationNames().size());
        Object derivedVariants = ImmutableList.of();
        if (variants.isEmpty() && (maybeDeriveVariants = metadata.maybeDeriveVariants()).isPresent()) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (ConfigurationMetadata derivedVariant : (ImmutableList)maybeDeriveVariants.get()) {
                ImmutableList dependencies = (ImmutableList)Cast.uncheckedCast(derivedVariant.getDependencies());
                RealisedConfigurationMetadata derivedVariantMetadata = new RealisedConfigurationMetadata(metadata.getId(), derivedVariant.getName(), derivedVariant.isTransitive(), derivedVariant.isVisible(), derivedVariant.getHierarchy(), (ImmutableList<? extends ModuleComponentArtifactMetadata>)((ImmutableList)Cast.uncheckedCast(derivedVariant.getArtifacts())), derivedVariant.getExcludes(), derivedVariant.getAttributes(), (ImmutableCapabilities)derivedVariant.getCapabilities(), derivedVariant.requiresMavenArtifactDiscovery(), (ImmutableList<ModuleDependencyMetadata>)dependencies, false);
                builder.add((Object)derivedVariantMetadata);
            }
            derivedVariants = RealisedMavenModuleResolveMetadata.addVariantsFromRules(metadata, (ImmutableList<ConfigurationMetadata>)builder.build(), variantMetadataRules);
        }
        for (String configurationName : metadata.getConfigurationNames()) {
            configurations.put(configurationName, RealisedMavenModuleResolveMetadata.createConfiguration(metadata, configurationName));
        }
        return new RealisedMavenModuleResolveMetadata(metadata, variants, (List<ConfigurationMetadata>)derivedVariants, configurations);
    }

    private static List<ConfigurationMetadata> addVariantsFromRules(ModuleComponentResolveMetadata componentMetadata, ImmutableList<ConfigurationMetadata> derivedVariants, VariantMetadataRules variantMetadataRules) {
        List<AdditionalVariant> additionalVariants = variantMetadataRules.getAdditionalVariants();
        if (additionalVariants.isEmpty()) {
            return derivedVariants;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(derivedVariants);
        Map variantsByName = derivedVariants.stream().collect(Collectors.toMap(ConfigurationMetadata::getName, Function.identity()));
        for (AdditionalVariant additionalVariant : additionalVariants) {
            ImmutableList artifacts;
            Object dependencies;
            ImmutableCapabilities capabilities;
            ImmutableAttributes attributes;
            String name = additionalVariant.getName();
            String baseName = additionalVariant.getBase();
            ConfigurationMetadata baseConf = (ConfigurationMetadata)variantsByName.get(baseName);
            if (baseConf == null) {
                attributes = componentMetadata.getAttributes();
                capabilities = ImmutableCapabilities.EMPTY;
                dependencies = ImmutableList.of();
                artifacts = ImmutableList.of();
            } else {
                attributes = baseConf.getAttributes();
                capabilities = (ImmutableCapabilities)baseConf.getCapabilities();
                dependencies = ((ModuleConfigurationMetadata)baseConf).getDependencies();
                artifacts = (ImmutableList)Cast.uncheckedCast(baseConf.getArtifacts());
            }
            if (baseName == null || baseConf != null) {
                builder.add((Object)RealisedMavenModuleResolveMetadata.applyRules(componentMetadata.getId(), name, variantMetadataRules, attributes, capabilities, (List<? extends ModuleDependencyMetadata>)dependencies, (ImmutableList<? extends ModuleComponentArtifactMetadata>)artifacts, true, true, (ImmutableSet<String>)ImmutableSet.of(), true));
                continue;
            }
            if (additionalVariant.isLenient()) continue;
            throw new InvalidUserDataException("Variant '" + baseName + "' not defined in module " + componentMetadata.getId().getDisplayName());
        }
        return builder.build();
    }

    private static RealisedConfigurationMetadata applyRules(ModuleComponentIdentifier id, String configurationName, VariantMetadataRules variantMetadataRules, ImmutableAttributes attributes, ImmutableCapabilities capabilities, List<? extends ModuleDependencyMetadata> dependencies, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, boolean addedByRule) {
        AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata variant = new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(configurationName);
        ImmutableAttributes variantAttributes = variantMetadataRules.applyVariantAttributeRules(variant, attributes);
        CapabilitiesMetadata capabilitiesMetadata = variantMetadataRules.applyCapabilitiesRules(variant, capabilities);
        List<? extends ModuleDependencyMetadata> dependenciesMetadata = variantMetadataRules.applyDependencyMetadataRules(variant, dependencies);
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifactsMetadata = variantMetadataRules.applyVariantFilesMetadataRulesToArtifacts(variant, artifacts, id);
        boolean mavenArtifactDiscovery = artifactsMetadata == artifacts;
        return RealisedMavenModuleResolveMetadata.createConfiguration(id, configurationName, transitive, visible, hierarchy, artifactsMetadata, dependenciesMetadata, variantAttributes, ImmutableCapabilities.of(capabilitiesMetadata.getCapabilities()), mavenArtifactDiscovery, addedByRule);
    }

    private static RealisedConfigurationMetadata createConfiguration(DefaultMavenModuleResolveMetadata metadata, String configurationName) {
        ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
        Configuration configuration = (Configuration)metadata.getConfigurationDefinitions().get((Object)configurationName);
        ImmutableSet<String> hierarchy = LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions);
        return RealisedMavenModuleResolveMetadata.createConfiguration(metadata.getId(), configurationName, configuration.isTransitive(), configuration.isVisible(), hierarchy, RealisedMavenModuleResolveMetadata.getArtifactsForConfiguration(metadata, configurationName), ((ModuleConfigurationMetadata)metadata.getConfiguration(configurationName)).getDependencies(), metadata.getAttributes(), ImmutableCapabilities.EMPTY, true, false);
    }

    private static RealisedConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, List<? extends DependencyMetadata> dependencies, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean mavenArtifactDiscovery, boolean addedByRule) {
        ImmutableList asImmutable = ImmutableList.copyOf((Collection)((Collection)Cast.uncheckedCast(dependencies)));
        return new RealisedConfigurationMetadata(componentId, name, transitive, visible, hierarchy, artifacts, (ImmutableList<ExcludeMetadata>)ImmutableList.of(), attributes, capabilities, mavenArtifactDiscovery, (ImmutableList<ModuleDependencyMetadata>)asImmutable, addedByRule);
    }

    static ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactsForConfiguration(DefaultMavenModuleResolveMetadata metadata, String name) {
        ImmutableList artifacts;
        if (name.equals("compile") || name.equals("runtime") || name.equals("default") || name.equals("test")) {
            String type = metadata.isKnownJarPackaging() ? "jar" : metadata.getPackaging();
            artifacts = ImmutableList.of((Object)new DefaultModuleComponentArtifactMetadata(metadata.getId(), new DefaultIvyArtifactName(metadata.getId().getModule(), type, type)));
        } else {
            artifacts = ImmutableList.of();
        }
        return artifacts;
    }

    private static ImmutableList<ModuleDependencyMetadata> filterDependencies(ModuleComponentIdentifier componentId, ConfigurationMetadata config, ImmutableList<MavenDependencyDescriptor> dependencies) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        boolean isOptionalConfiguration = "optional".equals(config.getName());
        for (MavenDependencyDescriptor dependency : dependencies) {
            if (isOptionalConfiguration && RealisedMavenModuleResolveMetadata.includeInOptionalConfiguration(dependency)) {
                filteredDependencies.add((Object)new DefaultMavenModuleResolveMetadata.OptionalConfigurationDependencyMetadata(config, componentId, dependency));
                continue;
            }
            if (!RealisedMavenModuleResolveMetadata.include(dependency, config.getHierarchy())) continue;
            filteredDependencies.add((Object)RealisedMavenModuleResolveMetadata.contextualize(config, componentId, dependency));
        }
        return filteredDependencies.build();
    }

    static ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, MavenDependencyDescriptor incoming) {
        ConfigurationBoundExternalDependencyMetadata dependency = new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
        dependency.alwaysUseAttributeMatching();
        return dependency;
    }

    private static boolean includeInOptionalConfiguration(MavenDependencyDescriptor dependency) {
        MavenScope dependencyScope = dependency.getScope();
        return dependency.isOptional() && dependencyScope != MavenScope.Test && dependencyScope != MavenScope.System;
    }

    private static boolean include(MavenDependencyDescriptor dependency, Collection<String> hierarchy) {
        MavenScope dependencyScope = dependency.getScope();
        if (dependency.isOptional()) {
            return false;
        }
        return hierarchy.contains(dependencyScope.getLowerName());
    }

    RealisedMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants, List<ConfigurationMetadata> derivedVariants, Map<String, ConfigurationMetadata> configurations) {
        super((AbstractModuleComponentResolveMetadata)metadata, variants, configurations);
        this.objectInstantiator = metadata.getObjectInstantiator();
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
        this.derivedVariants = ImmutableList.copyOf(derivedVariants);
    }

    private RealisedMavenModuleResolveMetadata(RealisedMavenModuleResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy derivationStrategy) {
        super(metadata, sources, derivationStrategy);
        this.objectInstantiator = metadata.objectInstantiator;
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.dependencies = metadata.dependencies;
        this.derivedVariants = metadata.derivedVariants;
    }

    @Override
    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return Optional.of(this.getDerivedVariants());
    }

    ImmutableList<? extends ConfigurationMetadata> getDerivedVariants() {
        return this.derivedVariants;
    }

    @Override
    public RealisedMavenModuleResolveMetadata withSources(ModuleSources sources) {
        return new RealisedMavenModuleResolveMetadata(this, sources, this.getVariantDerivationStrategy());
    }

    @Override
    public ModuleComponentResolveMetadata withDerivationStrategy(VariantDerivationStrategy derivationStrategy) {
        if (this.getVariantDerivationStrategy() == derivationStrategy) {
            return this;
        }
        return new RealisedMavenModuleResolveMetadata(this, this.getSources(), derivationStrategy);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this, this.objectInstantiator);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealisedMavenModuleResolveMetadata that = (RealisedMavenModuleResolveMetadata)o;
        return this.relocated == that.relocated && Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.snapshotTimestamp, (Object)that.snapshotTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.packaging, this.relocated, this.snapshotTimestamp});
    }
}

