/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.IncubationLogger;

public class DefaultProjectsPreparer
implements ProjectsPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectConfigurer projectConfigurer;
    private final ModelConfigurationListener modelConfigurationListener;

    public DefaultProjectsPreparer(ProjectConfigurer projectConfigurer, ModelConfigurationListener modelConfigurationListener, BuildOperationExecutor buildOperationExecutor) {
        this.projectConfigurer = projectConfigurer;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            IncubationLogger.incubatingFeatureUsed("Configuration on demand");
            this.projectConfigurer.configure(gradle.getRootProject());
        } else {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
            new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
        }
        this.modelConfigurationListener.onConfigure(gradle);
    }
}

