/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.GlobalCache;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.GradleVersion;

public class DefaultCacheScopeMapping
implements CacheScopeMapping,
GlobalCache {
    @VisibleForTesting
    public static final String GLOBAL_CACHE_DIR_NAME = "caches";
    private static final Pattern CACHE_KEY_NAME_PATTERN = Pattern.compile("\\p{Alpha}+[-/.\\w]*");
    private final File globalCacheDir;
    private final File projectCacheDir;
    private final GradleVersion version;

    public DefaultCacheScopeMapping(File userHomeDir, @Nullable File projectCacheDir, GradleVersion version) {
        this.version = version;
        this.globalCacheDir = new File(userHomeDir, GLOBAL_CACHE_DIR_NAME);
        this.projectCacheDir = projectCacheDir;
    }

    @Override
    public File getBaseDirectory(@Nullable Object scope, String key, VersionStrategy versionStrategy) {
        if (key.equalsIgnoreCase("projects") || key.equalsIgnoreCase("tasks") || !CACHE_KEY_NAME_PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException(String.format("Unsupported cache key '%s'.", key));
        }
        File cacheRootDir = this.getRootDirectory(scope);
        String subDir = key;
        if (scope instanceof Project) {
            Project project = (Project)scope;
            subDir = "projects/" + project.getPath().replace(':', '_') + "/" + key;
        }
        if (scope instanceof Task) {
            Task task = (Task)scope;
            subDir = "tasks/" + task.getPath().replace(':', '_') + "/" + key;
        }
        return this.getCacheDir(cacheRootDir, versionStrategy, subDir);
    }

    @Override
    public File getRootDirectory(@Nullable Object scope) {
        if (scope == null) {
            return this.globalCacheDir;
        }
        if (scope instanceof File) {
            return (File)scope;
        }
        if (scope instanceof Gradle) {
            Gradle gradle = (Gradle)scope;
            return this.getBuildCacheDir(gradle.getRootProject());
        }
        if (scope instanceof Project) {
            Project project = (Project)scope;
            return this.getBuildCacheDir(project.getRootProject());
        }
        if (scope instanceof Task) {
            Task task = (Task)scope;
            return this.getBuildCacheDir(task.getProject().getRootProject());
        }
        throw new IllegalArgumentException(String.format("Don't know how to determine the cache directory for scope of type %s.", scope.getClass().getSimpleName()));
    }

    private File getCacheDir(File rootDir, VersionStrategy versionStrategy, String subDir) {
        switch (versionStrategy) {
            case CachePerVersion: {
                return new File(rootDir, this.version.getVersion() + "/" + subDir);
            }
            case SharedCache: {
                return new File(rootDir, subDir);
            }
        }
        throw new IllegalArgumentException();
    }

    private File getBuildCacheDir(Project rootProject) {
        if (this.projectCacheDir != null) {
            return this.projectCacheDir;
        }
        return new File(rootProject.getProjectDir(), ".gradle");
    }

    @Override
    public List<File> getGlobalCacheRoots() {
        return ImmutableList.of((Object)this.globalCacheDir);
    }
}

