/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultMavenDeployment
implements MavenDeployment {
    private final String packaging;
    private final MavenProjectIdentity projectIdentity;
    private final PublishArtifact pomArtifact;
    private final PublishArtifact mainArtifact;
    private Set<PublishArtifact> attachedArtifacts;

    public DefaultMavenDeployment(String packaging, MavenProjectIdentity projectIdentity, PublishArtifact pomArtifact, PublishArtifact mainArtifact, Iterable<? extends PublishArtifact> attachedArtifacts) {
        this.packaging = packaging;
        this.projectIdentity = projectIdentity;
        this.pomArtifact = pomArtifact;
        this.mainArtifact = mainArtifact;
        this.attachedArtifacts = Sets.newLinkedHashSet(attachedArtifacts);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getGroupId() {
        return this.projectIdentity.getGroupId().get();
    }

    @Override
    public String getArtifactId() {
        return this.projectIdentity.getArtifactId().get();
    }

    @Override
    public String getVersion() {
        return this.projectIdentity.getVersion().get();
    }

    @Override
    public void addArtifact(PublishArtifact artifact) {
        this.attachedArtifacts.add(artifact);
    }

    @Override
    public PublishArtifact getPomArtifact() {
        return this.pomArtifact;
    }

    @Override
    public Set<PublishArtifact> getArtifacts() {
        HashSet<PublishArtifact> artifacts = new HashSet<PublishArtifact>();
        artifacts.addAll(this.attachedArtifacts);
        if (this.mainArtifact != null) {
            artifacts.add(this.mainArtifact);
        }
        artifacts.add(this.pomArtifact);
        return artifacts;
    }

    @Override
    public PublishArtifact getMainArtifact() {
        return this.mainArtifact;
    }

    @Override
    public Set<PublishArtifact> getAttachedArtifacts() {
        return this.attachedArtifacts;
    }
}

