/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.List;
import org.gradle.api.internal.file.pattern.AnythingMatcher;
import org.gradle.api.internal.file.pattern.EndOfPathMatcher;
import org.gradle.api.internal.file.pattern.FixedStepPathMatcher;
import org.gradle.api.internal.file.pattern.GreedyPathMatcher;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.CharMatcher;
import org.gradle.internal.impldep.com.google.common.base.Splitter;

public class PatternMatcherFactory {
    private static final EndOfPathMatcher END_OF_PATH_MATCHER = new EndOfPathMatcher();
    private static final Splitter PATH_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\\/")).omitEmptyStrings();

    public static PatternMatcher getPatternsMatcher(boolean partialMatchDirs, boolean caseSensitive, Iterable<String> patterns) {
        PatternMatcher matcher = PatternMatcher.MATCH_ALL;
        for (String pattern : patterns) {
            PatternMatcher patternMatcher = PatternMatcherFactory.getPatternMatcher(partialMatchDirs, caseSensitive, pattern);
            matcher = matcher == PatternMatcher.MATCH_ALL ? patternMatcher : matcher.or(patternMatcher);
        }
        return matcher;
    }

    public static PatternMatcher getPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String pattern) {
        PathMatcher pathMatcher = PatternMatcherFactory.compile(caseSensitive, pattern);
        return new DefaultPatternMatcher(partialMatchDirs, pathMatcher);
    }

    public static PathMatcher compile(boolean caseSensitive, String pattern) {
        if (pattern.length() == 0) {
            return END_OF_PATH_MATCHER;
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            pattern = pattern + "**";
        }
        List parts = PATH_SPLITTER.splitToList((CharSequence)pattern);
        return PatternMatcherFactory.compile(parts, 0, caseSensitive);
    }

    private static PathMatcher compile(List<String> parts, int startIndex, boolean caseSensitive) {
        int pos;
        if (startIndex >= parts.size()) {
            return END_OF_PATH_MATCHER;
        }
        for (pos = startIndex; pos < parts.size() && parts.get(pos).equals("**"); ++pos) {
        }
        if (pos > startIndex) {
            if (pos == parts.size()) {
                return new AnythingMatcher();
            }
            return new GreedyPathMatcher(PatternMatcherFactory.compile(parts, pos, caseSensitive));
        }
        return new FixedStepPathMatcher(PatternStepFactory.getStep(parts.get(pos), caseSensitive), PatternMatcherFactory.compile(parts, pos + 1, caseSensitive));
    }

    @VisibleForTesting
    static class DefaultPatternMatcher
    extends PatternMatcher {
        private final boolean partialMatchDirs;
        private final PathMatcher pathMatcher;

        public DefaultPatternMatcher(boolean partialMatchDirs, PathMatcher pathMatcher) {
            this.partialMatchDirs = partialMatchDirs;
            this.pathMatcher = pathMatcher;
        }

        @VisibleForTesting
        PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        @Override
        public boolean test(String[] segments, boolean file) {
            if (file || !this.partialMatchDirs) {
                return this.pathMatcher.matches(segments, 0);
            }
            return this.pathMatcher.isPrefix(segments, 0);
        }
    }
}

