/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.PropertyResourceBundleFallbackCharset;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.api.internal.changedetection.state.ZipEntryHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;

public class PropertiesFileZipEntryHasher
implements ZipEntryHasher,
ConfigurableNormalizer {
    private final ResourceEntryFilter propertyResourceFilter;

    public PropertiesFileZipEntryHasher(ResourceEntryFilter propertyResourceFilter) {
        this.propertyResourceFilter = propertyResourceFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.propertyResourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.hashProperties(ByteStreams.toByteArray((InputStream)zipEntryContext.getEntry().getInputStream()));
    }

    private HashCode hashProperties(byte[] entryBytes) throws IOException {
        Hasher hasher = Hashing.newHasher();
        Properties properties = new Properties();
        properties.load(new InputStreamReader((InputStream)new ByteArrayInputStream(entryBytes), new PropertyResourceBundleFallbackCharset()));
        ImmutableMap entries = Maps.fromProperties((Properties)properties);
        entries.entrySet().stream().filter(entry -> !this.propertyResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putString((CharSequence)entry.getValue());
        });
        return hasher.hash();
    }
}

