/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import org.gradle.api.Action;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

public abstract class StatefulIncrementalTaskInputs
implements IncrementalTaskInputs {
    private boolean outOfDateProcessed;
    private boolean removedProcessed;

    @Override
    public void outOfDate(Action<? super InputFileDetails> outOfDateAction) {
        if (this.outOfDateProcessed) {
            throw new IllegalStateException("Cannot process outOfDate files multiple times");
        }
        this.doOutOfDate(outOfDateAction);
        this.outOfDateProcessed = true;
    }

    protected abstract void doOutOfDate(Action<? super InputFileDetails> var1);

    @Override
    public void removed(Action<? super InputFileDetails> removedAction) {
        if (!this.outOfDateProcessed) {
            throw new IllegalStateException("Must first process outOfDate files before processing removed files");
        }
        if (this.removedProcessed) {
            throw new IllegalStateException("Cannot process removed files multiple times");
        }
        this.doRemoved(removedAction);
        this.removedProcessed = true;
    }

    protected abstract void doRemoved(Action<? super InputFileDetails> var1);
}

