/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.css.impl.util.editor.IndentedRulesetBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSElementTypes;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.scss.formatter.SCSSRulesetBlock;

public class SassRulesetBlock
extends IndentedRulesetBlock {
    private static final TokenSet ELEMENT_HANDLING_TYPED_ENTER = TokenSet.create((IElementType[])new IElementType[]{SASSElementTypes.RULESET, CssElementTypes.CSS_MEDIA, CssElementTypes.CSS_SUPPORTS, CssElementTypes.CSS_VIEWPORT, SASSElementTypes.PROPERTY_RULESET, SASSElementTypes.MIXIN, SASSElementTypes.IF_STATEMENT, CssElementTypes.CSS_KEYFRAMES_RULE, SASSElementTypes.WHILE_STATEMENT, SASSElementTypes.FOR_STATEMENT, CssElementTypes.CSS_DECLARATION_BLOCK, SASSElementTypes.FUNCTION_DECLARATION});
    private static final TokenSet INDENTS_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{SASSElementTypes.RULESET, SASSElementTypes.IF_STATEMENT, SASSElementTypes.WHILE_STATEMENT, SASSElementTypes.FOR_STATEMENT, CssElementTypes.CSS_MEDIA, CssElementTypes.CSS_SUPPORTS, CssElementTypes.CSS_VIEWPORT, CssElementTypes.CSS_KEYFRAMES_RULE, CssElementTypes.CSS_DECLARATION_BLOCK, SASSElementTypes.PROPERTY_RULESET, SASSElementTypes.MIXIN, SASSElementTypes.FUNCTION_DECLARATION});

    public SassRulesetBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension, Alignment alignment) {
        super(_node, indent, extension, alignment);
    }

    protected TokenSet getElementsHandlingEnter() {
        return ELEMENT_HANDLING_TYPED_ENTER;
    }

    protected TokenSet getElementsIndentingChildren() {
        return INDENTS_CHILDREN;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            SassRulesetBlock.$$$reportNull$$$0(0);
        }
        if (!(child1 instanceof CssFormattingModelBuilder.CssFormatterBlock) || !(child2 instanceof CssFormattingModelBuilder.CssFormatterBlock)) {
            return super.getSpacing(child1, child2);
        }
        CssFormattingModelBuilder.CssFormatterBlock formatterBlock1 = (CssFormattingModelBuilder.CssFormatterBlock)child1;
        CssFormattingModelBuilder.CssFormatterBlock formatterBlock2 = (CssFormattingModelBuilder.CssFormatterBlock)child2;
        IElementType blockType1 = formatterBlock1.getNode().getElementType();
        IElementType blockType2 = formatterBlock2.getNode().getElementType();
        if (SASSTokenTypes.LOOPS.contains(blockType1) || SASSTokenTypes.IF == blockType1) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        ASTNode blockParent2 = formatterBlock2.getNode().getTreeParent();
        if (formatterBlock2 instanceof CssFormattingModelBuilder.CssPropertyBlock && !(formatterBlock2 instanceof CssFormattingModelBuilder.CssTermListBlock) && blockParent2.getElementType() != CssElementTypes.CSS_MEDIA_EXPRESSION && blockParent2.getElementType() != CssElementTypes.CSS_SUPPORTS || formatterBlock2 instanceof CssFormattingModelBuilder.CssMediaBlock) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
        }
        if (this.getNode().getElementType() == SASSElementTypes.PROPERTY_RULESET && ":".equals(formatterBlock1.getNode().getText())) {
            return blockType2 == SASSTokenTypes.IDENTIFIER ? Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (formatterBlock1.getNode().getTreeParent().getElementType() == SASSElementTypes.MIXIN && blockType1 == SASSTokenTypes.EQUALS && SASSTokenTypes.MIXIN_NAMES.contains(blockType2)) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)0);
        }
        if (blockType1 == CssElementTypes.CSS_LPAREN || (this.getNode().getElementType() == SASSElementTypes.MIXIN || blockType1 == CssElementTypes.CSS_FUNCTION_TOKEN) && blockType2 == CssElementTypes.CSS_LPAREN || blockType2 == CssElementTypes.CSS_RPAREN) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (this.myExtension.isComment(blockType2)) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
        }
        if (!SASSTokenTypes.KEYWORDS.contains(blockType1) && SASSTokenTypes.KEYWORDS.contains(blockType2)) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
        }
        return new SCSSRulesetBlock(this.myNode, this.getIndent(), this.myExtension, this.getAlignment()).getSpacing(child1, child2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/sass/formatter/SassRulesetBlock", "getSpacing"));
    }
}

