/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public final class ConfigYamlUtils {
    private static final LookupElementRenderer<LookupElement> YAML_PLACEHOLDER_LOOKUP_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element.getObject();
            presentation.setIcon(PlatformIcons.PROPERTY_ICON);
            presentation.setItemText(ConfigYamlUtils.getQualifiedConfigKeyName(yamlKeyValue));
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
            String value = ConfigYamlUtils.getValuePresentationText(yamlKeyValue);
            presentation.setTailText("=" + value, attrs.getForegroundColor());
        }
    };
    private static final InsertHandler<LookupElement> INSERT_COLON_AN_NEW_LINE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (lookupElement == null) {
                2.$$$reportNull$$$0(1);
            }
            PsiElement element = context.getFile().findElementAt(context.getStartOffset());
            assert (element != null) : "no element at " + context.getStartOffset();
            int indent = YAMLUtil.getIndentToThisElement((PsiElement)element) + 2;
            String insertion = "\n" + StringUtil.repeatSymbol((char)' ', (int)indent);
            Editor editor = context.getEditor();
            if (!YamlKeyCompletionInsertHandler.isCharAtCaret((Editor)editor, (char)':')) {
                insertion = ":" + insertion;
            } else {
                editor.getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)insertion);
            AutoPopupController.getInstance((Project)Objects.requireNonNull(editor.getProject())).scheduleAutoPopup(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lookupElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/microservices/config/yaml/ConfigYamlUtils$2";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final int VALUE_PRESENTATION_MAX_ITEMS = 2;
    @NonNls
    private static final String MORE_ITEMS_TEXT = ", [...]";

    private ConfigYamlUtils() {
    }

    @NotNull
    public static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue) {
        return ConfigYamlUtils.getQualifiedConfigKeyName(yamlKeyValue, YAMLKeyValue::getKeyText);
    }

    @NotNull
    public static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue, Function<YAMLKeyValue, String> keyTextMapper) {
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        boolean addSeparator = false;
        while (element != null) {
            YAMLSequenceItem item;
            if (addSeparator) {
                builder.insert(0, '.');
            }
            builder.insert(0, keyTextMapper.apply(element));
            addSeparator = true;
            YAMLKeyValue parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)true, (Class[])new Class[]{YAMLSequenceItem.class});
            if (parent == null && (item = (YAMLSequenceItem)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLSequenceItem.class)) != null) {
                int index;
                YAMLSequence sequence = (YAMLSequence)PsiTreeUtil.getParentOfType((PsiElement)item, YAMLSequence.class);
                if (sequence != null && (index = sequence.getItems().indexOf(item)) >= 0) {
                    builder.insert(0, "[" + index + "].");
                    addSeparator = false;
                }
                parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            }
            element = parent;
        }
        String string = builder.toString();
        if (string == null) {
            ConfigYamlUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getValuePresentationText(YAMLKeyValue yamlKeyValue) {
        YAMLValue value = yamlKeyValue.getValue();
        if (value instanceof YAMLScalar) {
            String string = ((YAMLScalar)value).getTextValue();
            if (string == null) {
                ConfigYamlUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (value instanceof YAMLSequence) {
            List sequenceItems = ((YAMLSequence)value).getItems();
            String suffix = sequenceItems.size() > 2 ? MORE_ITEMS_TEXT : "";
            String string = StringUtil.join((Collection)ContainerUtil.getFirstItems((List)sequenceItems, (int)2), item -> {
                YAMLValue itemValue = item.getValue();
                if (itemValue instanceof YAMLScalar) {
                    return ((YAMLScalar)itemValue).getTextValue();
                }
                return ConfigYamlUtils.getSequenceItemText(item);
            }, (String)", ") + suffix;
            if (string == null) {
                ConfigYamlUtils.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = yamlKeyValue.getValueText();
        if (string == null) {
            ConfigYamlUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getSequenceItemText(YAMLSequenceItem item) {
        SmartList keysValues = new SmartList();
        int count = 0;
        String suffix = "";
        Iterator iterator = item.getKeysValues().iterator();
        while (iterator.hasNext()) {
            YAMLKeyValue next = (YAMLKeyValue)iterator.next();
            keysValues.add(next);
            if (count++ != 2) continue;
            if (!iterator.hasNext()) break;
            suffix = MORE_ITEMS_TEXT;
            break;
        }
        String string = StringUtil.join((Collection)keysValues, keyValue -> keyValue.getKeyText() + ": " + ConfigYamlUtils.getValuePresentationText(keyValue), (String)", ") + suffix;
        if (string == null) {
            ConfigYamlUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static LookupElementRenderer<LookupElement> getYamlPlaceholderLookupRenderer() {
        LookupElementRenderer<LookupElement> lookupElementRenderer = YAML_PLACEHOLDER_LOOKUP_RENDERER;
        if (lookupElementRenderer == null) {
            ConfigYamlUtils.$$$reportNull$$$0(5);
        }
        return lookupElementRenderer;
    }

    @Nullable
    public static YAMLKeyValue getParentKeyValue(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        YAMLKeyValue parentYamlKeyValue;
        if (element == null) {
            ConfigYamlUtils.$$$reportNull$$$0(6);
        }
        if ((parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)originalElement, YAMLKeyValue.class)) == null) {
            parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
        }
        if (element.getNode().getElementType() == YAMLTokenTypes.SCALAR_KEY) {
            parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)parentYamlKeyValue, YAMLKeyValue.class);
        }
        return parentYamlKeyValue;
    }

    @NotNull
    public static List<LookupElement> getCurrentLineKeyComponents(@Nullable PsiElement originalElement, @NotNull MetaConfigKeyManager.ConfigKeyNameBinder binder, @NotNull String parentConfigKeyName, @NotNull List<? extends MetaConfigKey> configKeys) {
        if (binder == null) {
            ConfigYamlUtils.$$$reportNull$$$0(7);
        }
        if (parentConfigKeyName == null) {
            ConfigYamlUtils.$$$reportNull$$$0(8);
        }
        if (configKeys == null) {
            ConfigYamlUtils.$$$reportNull$$$0(9);
        }
        if (originalElement == null || originalElement.getNode().getElementType() != YAMLTokenTypes.SCALAR_KEY && !(originalElement.getParent() instanceof YAMLScalar)) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                ConfigYamlUtils.$$$reportNull$$$0(10);
            }
            return list;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        int parentComponents = parentConfigKeyName.isEmpty() ? 0 : StringUtil.countChars((CharSequence)parentConfigKeyName, (char)'.') + 1;
        for (MetaConfigKey metaConfigKey : configKeys) {
            List components;
            if (!parentConfigKeyName.isEmpty() && !binder.matchesPrefix(metaConfigKey, parentConfigKeyName) || (components = StringUtil.split((String)metaConfigKey.getName(), (String)".")).size() <= parentComponents + 1) continue;
            keys.add((String)components.get(parentComponents));
        }
        List list = ContainerUtil.map(keys, key -> LookupElementBuilder.create((String)key).withIcon(AllIcons.Nodes.Property).withInsertHandler(INSERT_COLON_AN_NEW_LINE_INSERT_HANDLER));
        if (list == null) {
            ConfigYamlUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void addCompletionAddIfNeeded(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            ConfigYamlUtils.$$$reportNull$$$0(12);
        }
        if (result == null) {
            ConfigYamlUtils.$$$reportNull$$$0(13);
        }
        if (parameters.getInvocationCount() <= 1) {
            result.addLookupAdvertisement(MicroservicesConfigBundle.message("config.completion.ad", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/config/yaml/ConfigYamlUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentConfigKeyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeys";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedConfigKeyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentationText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSequenceItemText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getYamlPlaceholderLookupRenderer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/config/yaml/ConfigYamlUtils";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLineKeyComponents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentKeyValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLineKeyComponents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionAddIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

