/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config.yaml;

import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

public class ConfigYamlAccessor {
    @Nullable
    private final YAMLDocument myDocument;
    private final Module myModule;
    private final MetaConfigKeyManager myManager;

    public ConfigYamlAccessor(@Nullable YAMLDocument document, @Nullable Module module, @NotNull MetaConfigKeyManager metaConfigKeyManager) {
        if (metaConfigKeyManager == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        this.myModule = module;
        this.myManager = metaConfigKeyManager;
    }

    public ConfigYamlAccessor(@Nullable YAMLDocument document, @NotNull MetaConfigKeyManager metaConfigKeyManager) {
        if (metaConfigKeyManager == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(1);
        }
        this(document, null, metaConfigKeyManager);
    }

    public ConfigYamlAccessor(PsiElement context, @NotNull MetaConfigKeyManager metaConfigKeyManager) {
        if (metaConfigKeyManager == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(2);
        }
        this((YAMLDocument)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{YAMLDocument.class}), metaConfigKeyManager);
    }

    private boolean isValid() {
        return this.myDocument != null;
    }

    @Nullable
    public YAMLKeyValue findExistingKey(@NotNull String qualifiedKey) {
        if (qualifiedKey == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(3);
        }
        if (!this.isValid()) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)qualifiedKey)) {
            return null;
        }
        YAMLValue searchElement = this.myDocument.getTopLevelValue();
        List key = StringUtil.split((String)qualifiedKey, (String)".");
        MetaConfigKeyManager.ConfigKeyNameBinder binder = this.getBinder();
        for (int i = 0; i < key.size(); ++i) {
            if (!(searchElement instanceof YAMLMapping)) {
                return null;
            }
            String subKey = (String)key.get(i);
            YAMLKeyValue relaxedChild = ConfigYamlAccessor.findChildRelaxed((YAMLMapping)searchElement, subKey, binder);
            if (relaxedChild == null || i + 1 == key.size()) {
                return relaxedChild;
            }
            searchElement = relaxedChild.getValue();
        }
        throw new IllegalStateException("Should have returned from the loop '" + qualifiedKey + "'");
    }

    @NotNull
    private MetaConfigKeyManager.ConfigKeyNameBinder getBinder() {
        Module module;
        Module module2 = module = this.myModule != null ? this.myModule : ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myDocument);
        assert (module != null) : "could not find module for accessor document";
        MetaConfigKeyManager.ConfigKeyNameBinder configKeyNameBinder = this.myManager.getConfigKeyNameBinder(module);
        if (configKeyNameBinder == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(4);
        }
        return configKeyNameBinder;
    }

    @Nullable
    private static YAMLKeyValue findChildRelaxed(@NotNull YAMLMapping searchElement, String subKey, @NotNull MetaConfigKeyManager.ConfigKeyNameBinder binder) {
        YAMLKeyValue byKey;
        if (searchElement == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(5);
        }
        if (binder == null) {
            ConfigYamlAccessor.$$$reportNull$$$0(6);
        }
        if ((byKey = searchElement.getKeyValueByKey(subKey)) != null) {
            return byKey;
        }
        for (YAMLKeyValue value : searchElement.getKeyValues()) {
            String name = value.getName();
            if (name == null || !binder.matchesPart(subKey, name)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public YAMLKeyValue create(String qualifiedKey) throws IncorrectOperationException {
        Runnable writeRunnable;
        if (!this.isValid()) {
            return null;
        }
        List keyParts = StringUtil.split((String)qualifiedKey, (String)".");
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)this.myDocument.getProject());
        if (!(this.myDocument.getTopLevelValue() instanceof YAMLMapping)) {
            YAMLFile dummyFile = generator.createDummyYamlWithText(YAMLElementGenerator.createChainedKey((List)keyParts, (int)0));
            YAMLValue dummyValue = ((YAMLDocument)dummyFile.getDocuments().get(0)).getTopLevelValue();
            assert (dummyValue != null);
            writeRunnable = () -> {
                if (this.myDocument.getTopLevelValue() == null) {
                    this.myDocument.add((PsiElement)dummyValue);
                } else {
                    this.myDocument.getTopLevelValue().replace((PsiElement)dummyValue);
                }
            };
        } else {
            YAMLMapping topMostExistingMapping = (YAMLMapping)this.myDocument.getTopLevelValue();
            YAMLKeyValue topMostExistingKey = null;
            int foundHierarchies = 0;
            for (String subKey : keyParts) {
                if (topMostExistingMapping == null || (topMostExistingKey = ConfigYamlAccessor.findChildRelaxed(topMostExistingMapping, subKey, this.getBinder())) == null) break;
                topMostExistingMapping = (YAMLMapping)ObjectUtils.tryCast((Object)topMostExistingKey.getValue(), YAMLMapping.class);
                ++foundHierarchies;
            }
            if (foundHierarchies == keyParts.size()) {
                throw new IncorrectOperationException("key exists already: " + qualifiedKey + "\n" + this.myDocument.getText());
            }
            assert (topMostExistingKey != null || topMostExistingMapping != null);
            int indent = topMostExistingMapping != null ? YAMLUtil.getIndentToThisElement((PsiElement)topMostExistingMapping) : YAMLUtil.getIndentToThisElement(topMostExistingKey) + 2;
            String chainedKey = YAMLElementGenerator.createChainedKey(keyParts.subList(foundHierarchies, keyParts.size()), (int)indent);
            YAMLFile dummyFile = generator.createDummyYamlWithText(chainedKey);
            Collection topLevelKeys = YAMLUtil.getTopLevelKeys((YAMLFile)dummyFile);
            if (topLevelKeys.isEmpty()) {
                throw new IllegalStateException("no top level keys (" + chainedKey + "): " + this.myDocument.getText());
            }
            YAMLKeyValue dummyKeyValue = (YAMLKeyValue)topLevelKeys.iterator().next();
            if (dummyKeyValue.getParentMapping() == null) {
                throw new IllegalStateException("no containing mapping for a kv (" + chainedKey + "): " + this.myDocument.getText());
            }
            if (topMostExistingMapping == null) {
                YAMLKeyValue finalTopMostExistingKey = topMostExistingKey;
                writeRunnable = () -> finalTopMostExistingKey.setValue((YAMLValue)dummyKeyValue.getParentMapping());
            } else {
                YAMLMapping finalTopMostExistingMapping = topMostExistingMapping;
                writeRunnable = () -> finalTopMostExistingMapping.putKeyValue(dummyKeyValue);
            }
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myDocument.getProject(), (String)MicroservicesConfigBundle.message("config.insert.key", qualifiedKey), null, (Runnable)writeRunnable, (PsiFile[])new PsiFile[0]);
        return this.findExistingKey(qualifiedKey);
    }

    public List<YAMLKeyValue> getAllKeys() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<YAMLKeyValue> allKeys = new ArrayList<YAMLKeyValue>();
        Processor collectProcessor = Processors.cancelableCollectProcessor(allKeys);
        ConfigYamlAccessor.processAllKeys((YAMLPsiElement)this.myDocument, (Processor<? super YAMLKeyValue>)collectProcessor);
        return allKeys;
    }

    public static boolean processAllKeys(YAMLPsiElement start, Processor<? super YAMLKeyValue> processor) {
        for (YAMLPsiElement element : start.getYAMLElements()) {
            if (element instanceof YAMLKeyValue) {
                YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
                YAMLValue value = yamlKeyValue.getValue();
                if (!processor.process((Object)yamlKeyValue)) {
                    return false;
                }
                if (value instanceof YAMLScalar) continue;
            }
            if (ConfigYamlAccessor.processAllKeys(element, processor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaConfigKeyManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/config/yaml/ConfigYamlAccessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/config/yaml/ConfigYamlAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingKey";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildRelaxed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

