/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class MetaConfigKeyLookupElementBuilder {
    private static final Key<MetaConfigKey> MY_KEY = Key.create((String)"CONFIG_KEY");
    private static final LookupElementRenderer<LookupElement> MY_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            String shortDescription;
            MetaConfigKey configKey = (MetaConfigKey)element.getUserData(MY_KEY);
            assert (configKey != null);
            presentation.setIcon(configKey.getPresentation().getIcon());
            MetaConfigKey.Deprecation deprecation = configKey.getDeprecation();
            presentation.setStrikeout(deprecation != MetaConfigKey.Deprecation.NOT_DEPRECATED);
            if (deprecation.getLevel() == MetaConfigKey.Deprecation.DeprecationLevel.ERROR) {
                presentation.setItemTextForeground((Color)JBColor.RED);
            }
            String lookupString = element.getLookupString();
            presentation.setItemText(lookupString);
            if (!lookupString.equals(configKey.getName())) {
                presentation.setItemTextBold(true);
            }
            if (configKey.getDefaultValue() != null) {
                String shortenedDefaultValue = StringUtil.shortenTextWithEllipsis((String)configKey.getDefaultValue(), (int)60, (int)0, (boolean)true);
                TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
                presentation.setTailText("=" + shortenedDefaultValue, attrs.getForegroundColor());
            }
            if (StringUtil.isNotEmpty((String)(shortDescription = configKey.getDescriptionText().getShortText()))) {
                presentation.appendTailText(" (" + shortDescription + ")", true);
            }
            if (configKey.getType() != null) {
                presentation.setTypeText(configKey.getType().getPresentableText());
                if (configKey.getDeclarationResolveResult() == MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE) {
                    presentation.setTypeGrayed(true);
                }
            }
        }
    };

    @NotNull
    public static LookupElementBuilder create(MetaConfigKey configKey, String lookupString) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)configKey.getDeclaration(), (String)lookupString).withRenderer(MY_RENDERER);
        builder.putUserData(MY_KEY, (Object)configKey);
        LookupElementBuilder lookupElementBuilder = builder;
        if (lookupElementBuilder == null) {
            MetaConfigKeyLookupElementBuilder.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/microservices/config/MetaConfigKeyLookupElementBuilder", "create"));
    }
}

