/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigKeyParts {
    private static final char CONFIG_KEY_SEPARATOR = '.';
    private static final CharFilter KEY_INDEX_CHAR_FILTER = ch -> Character.isLetterOrDigit(ch) || ch == '-';
    private final String myConfigKey;
    private final String myKeyIndex;
    private final String myKeyProperty;

    private ConfigKeyParts(@NotNull String configKey, @Nullable String keyIndex, @Nullable String keyProperty) {
        if (configKey == null) {
            ConfigKeyParts.$$$reportNull$$$0(0);
        }
        this.myConfigKey = configKey;
        this.myKeyIndex = keyIndex;
        this.myKeyProperty = keyProperty;
    }

    @NotNull
    public String getConfigKey() {
        String string = this.myConfigKey;
        if (string == null) {
            ConfigKeyParts.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getKeyIndex() {
        return this.myKeyIndex;
    }

    @Nullable
    public String getKeyProperty() {
        return this.myKeyProperty;
    }

    public boolean matchesKeyName(@NotNull String keyName, @NotNull BiPredicate<String, String> matcher) {
        if (keyName == null) {
            ConfigKeyParts.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            ConfigKeyParts.$$$reportNull$$$0(3);
        }
        return matcher.test(keyName, this.myConfigKey);
    }

    @Nullable
    public String getKeyIndexIfMatches(@NotNull String keyName, @Nullable String keyProperty, @NotNull BiPredicate<String, String> matcher) {
        if (keyName == null) {
            ConfigKeyParts.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            ConfigKeyParts.$$$reportNull$$$0(5);
        }
        if (this.myKeyIndex != null && this.matchesKeyName(keyName, matcher) && (keyProperty == null || this.myKeyProperty != null && matcher.test(keyProperty, this.myKeyProperty))) {
            return this.myKeyIndex;
        }
        return null;
    }

    @Nullable
    public static ConfigKeyParts splitToParts(@NotNull MetaConfigKey key, @NotNull String configKeyText, boolean filterKeyIndex) {
        String keyIndex;
        int propertySeparatorIndex;
        if (key == null) {
            ConfigKeyParts.$$$reportNull$$$0(6);
        }
        if (configKeyText == null) {
            ConfigKeyParts.$$$reportNull$$$0(7);
        }
        if (configKeyText.isEmpty() || configKeyText.equals(".")) {
            return null;
        }
        String keyName = key.getName();
        int keyNameSeparatorsCount = StringUtil.countChars((CharSequence)keyName, (char)'.');
        int separatorIndex = -1;
        for (int i = 0; i < keyNameSeparatorsCount; ++i) {
            if ((separatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(separatorIndex + 1))) >= 0) continue;
            return null;
        }
        int keySeparatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(separatorIndex + 1));
        int bracketIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'[', (int)(separatorIndex + 1));
        if (keySeparatorIndex < 0 || bracketIndex >= 0 && bracketIndex < keySeparatorIndex) {
            keySeparatorIndex = bracketIndex;
        }
        if (keySeparatorIndex < 0) {
            return new ConfigKeyParts(configKeyText, null, null);
        }
        String keyNamePrefix = configKeyText.substring(0, keySeparatorIndex);
        Character indexEndingSeparator = null;
        if (configKeyText.charAt(keySeparatorIndex) == '.' && keySeparatorIndex != configKeyText.length() - 1) {
            char indexSeparatorChar = configKeyText.charAt(keySeparatorIndex + 1);
            if (indexSeparatorChar == '[') {
                indexEndingSeparator = Character.valueOf(']');
                ++keySeparatorIndex;
            } else if (indexSeparatorChar == '\"') {
                indexEndingSeparator = Character.valueOf('\"');
                ++keySeparatorIndex;
            }
        }
        if (keySeparatorIndex == configKeyText.length() - 1) {
            return new ConfigKeyParts(keyNamePrefix, null, null);
        }
        if (indexEndingSeparator == null && configKeyText.charAt(keySeparatorIndex) == '[') {
            indexEndingSeparator = Character.valueOf(']');
        }
        if (indexEndingSeparator != null) {
            propertySeparatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)indexEndingSeparator.charValue(), (int)(keySeparatorIndex + 1));
            String string = keyIndex = propertySeparatorIndex >= 0 ? configKeyText.substring(keySeparatorIndex + 1, propertySeparatorIndex) : configKeyText.substring(keySeparatorIndex + 1);
            if (propertySeparatorIndex >= 0 && propertySeparatorIndex != configKeyText.length() - 1 && configKeyText.charAt(propertySeparatorIndex + 1) == '.') {
                ++propertySeparatorIndex;
            }
        } else {
            propertySeparatorIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(keySeparatorIndex + 1));
            String string = keyIndex = propertySeparatorIndex >= 0 ? configKeyText.substring(keySeparatorIndex + 1, propertySeparatorIndex) : configKeyText.substring(keySeparatorIndex + 1);
            if (filterKeyIndex && !StringUtil.isLatinAlphanumeric((CharSequence)keyIndex)) {
                keyIndex = StringUtil.strip((String)keyIndex, (CharFilter)KEY_INDEX_CHAR_FILTER);
            }
        }
        String keyProperty = propertySeparatorIndex < 0 || propertySeparatorIndex == configKeyText.length() - 1 ? null : configKeyText.substring(propertySeparatorIndex + 1);
        return new ConfigKeyParts(keyNamePrefix, keyIndex, keyProperty);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/config/ConfigKeyParts";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/config/ConfigKeyParts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesKeyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeyIndexIfMatches";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitToParts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

