/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.recommenders.java.commons.names;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jetbrains.recommenders.java.commons.names.IMethodName;
import com.jetbrains.recommenders.java.commons.names.IPackageName;
import com.jetbrains.recommenders.java.commons.names.ITypeName;
import com.jetbrains.recommenders.java.commons.names.VmMethodName;
import com.jetbrains.recommenders.java.commons.names.VmPackageName;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/recommenders/java/commons/names/VmTypeName;", "Lcom/jetbrains/recommenders/java/commons/names/ITypeName;", "vmTypeName", "", "(Ljava/lang/Object;)V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "setIdentifier", "(Ljava/lang/String;)V", "compareTo", "", "other", "getArrayComponentType", "getArrayDimensions", "getClassName", "getDeclaringMethod", "Lcom/jetbrains/recommenders/java/commons/names/IMethodName;", "getDeclaringType", "getPackage", "Lcom/jetbrains/recommenders/java/commons/names/IPackageName;", "isAnonymousType", "", "isArrayType", "isBaseType", "isNestedType", "isObjectType", "isVoid", "toString", "Companion", "recommenders-java-commons"})
public final class VmTypeName
implements ITypeName {
    @NotNull
    private String identifier;
    private static final Pattern GENERICS_PATTERN;
    private static final Cache<String, VmTypeName> index;
    @JvmField
    @NotNull
    public static final VmTypeName JAVA_LANG_BOOLEAN;
    @JvmField
    @NotNull
    public static final VmTypeName JAVA_LANG_STRING;
    @JvmField
    @NotNull
    public static final VmTypeName JAVA_LANG_SYSTEM;
    @JvmField
    @NotNull
    public static final VmTypeName JAVA_LANG_NULL_POINTER_EXCEPTION;
    @JvmField
    @NotNull
    public static final VmTypeName JAVA_LANG_EXCEPTION_IN_INITIALIZER_ERROR;
    @JvmField
    @NotNull
    public static final VmTypeName OBJECT;
    @JvmField
    @NotNull
    public static final VmTypeName STRING;
    @JvmField
    @NotNull
    public static final VmTypeName NULL;
    @JvmField
    @NotNull
    public static final VmTypeName ANY;
    @JvmField
    @NotNull
    public static final VmTypeName ERASED;
    @JvmField
    @NotNull
    public static final VmTypeName BYTE;
    @JvmField
    @NotNull
    public static final VmTypeName BOOLEAN;
    @JvmField
    @NotNull
    public static final VmTypeName CHAR;
    @JvmField
    @NotNull
    public static final VmTypeName DOUBLE;
    @JvmField
    @NotNull
    public static final VmTypeName FLOAT;
    @JvmField
    @NotNull
    public static final VmTypeName INT;
    @JvmField
    @NotNull
    public static final VmTypeName LONG;
    @JvmField
    @NotNull
    public static final VmTypeName SHORT;
    @JvmField
    @NotNull
    public static final VmTypeName VOID;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.identifier = string;
    }

    @Override
    @NotNull
    public ITypeName getArrayComponentType() {
        boolean bl = this.isArrayType();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "only array-types have a base type!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int start = 0;
        while (this.getIdentifier().charAt(++start) == '[') {
        }
        String string = this.getIdentifier();
        Companion companion = Companion;
        bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string3;
        return companion.of(string4);
    }

    @Override
    public boolean isArrayType() {
        return this.getIdentifier().charAt(0) == '[';
    }

    @Override
    @NotNull
    public IMethodName getDeclaringMethod() {
        boolean bl = this.isNestedType();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "only valid on nested types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int lastPathSegmentSeparator = StringsKt.lastIndexOf$default((CharSequence)this.getIdentifier(), (char)'/', (int)0, (boolean)false, (int)6, null);
        String string = this.getIdentifier();
        int bl4 = 0;
        boolean bl5 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(bl4, lastPathSegmentSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String path = string3;
        int bracket = StringsKt.lastIndexOf$default((CharSequence)path, (char)'(', (int)0, (boolean)false, (int)6, null);
        int methodSeparator = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)bracket, (boolean)false, (int)4, null);
        String string4 = path;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl6 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, methodSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string7 = string6;
        string4 = path;
        n = methodSeparator + 1;
        stringBuilder = stringBuilder.append(string7).append(".");
        bl6 = false;
        String string8 = string4;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
        string7 = string9;
        String newFQName = stringBuilder.append(string7).toString();
        return VmMethodName.Companion.of(newFQName);
    }

    @Override
    public boolean isNestedType() {
        return StringsKt.contains$default((CharSequence)this.getIdentifier(), (CharSequence)"$", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public ITypeName getDeclaringType() {
        Preconditions.checkArgument((boolean)this.isNestedType(), (String)"only valid on nested types", (Object[])new Object[0]);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)this.getIdentifier(), (char)'$', (int)0, (boolean)false, (int)6, null);
        String string = this.getIdentifier();
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, lastIndexOf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String declaringTypeName = string3;
        return Companion.of(declaringTypeName);
    }

    @Override
    @NotNull
    public IPackageName getPackage() {
        IPackageName iPackageName;
        int lastSlash = StringsKt.lastIndexOf$default((CharSequence)this.getIdentifier(), (char)'/', (int)0, (boolean)false, (int)6, null);
        if (lastSlash == -1 || this.getIdentifier().charAt(0) == '[') {
            iPackageName = VmPackageName.DEFAULT_PACKAGE;
        } else {
            String string = this.getIdentifier();
            int n = 1;
            VmPackageName.Companion companion = VmPackageName.Companion;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, lastSlash);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            iPackageName = companion.of(string4);
        }
        return iPackageName;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string;
        int indexOf = StringsKt.lastIndexOf$default((CharSequence)this.getIdentifier(), (char)'/', (int)0, (boolean)false, (int)6, null);
        if (indexOf < 0 && !this.isBaseType()) {
            String string2 = this.getIdentifier();
            int n = 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            String string5 = this.getIdentifier();
            int n = indexOf + 1;
            boolean bl = false;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @Override
    public boolean isBaseType() {
        return !this.isArrayType() && !this.isObjectType();
    }

    @Override
    public boolean isObjectType() {
        return this.getIdentifier().charAt(0) == 'L';
    }

    @Override
    public boolean isAnonymousType() {
        CharSequence charSequence = this.getIdentifier();
        Regex regex = new Regex(".*\\$\\d+");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    @Override
    public boolean isVoid() {
        return this == VOID;
    }

    @Override
    public int getArrayDimensions() {
        int count = 0;
        int start = 0;
        while (this.getIdentifier().charAt(start++) == '[') {
            ++count;
        }
        return count;
    }

    @Override
    public int compareTo(@Nullable ITypeName other) {
        String string = this.getIdentifier();
        ITypeName iTypeName = other;
        String string2 = iTypeName != null ? iTypeName.getIdentifier() : null;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return string.compareTo(string2);
    }

    @Override
    @JsonValue
    @NotNull
    public String toString() {
        return this.getIdentifier();
    }

    private VmTypeName(Object vmTypeName) {
        this.identifier = vmTypeName.toString();
        CharSequence charSequence = this.getIdentifier();
        int n = 0;
        boolean bl = charSequence.length() > 0;
        n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "empty size for type name not permitted";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = this.getIdentifier();
        int n2 = string.length();
        block4: for (n = 0; n < n2; ++n) {
            char element = string.charAt(n);
            switch (element) {
                case '[': {
                    continue block4;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break block4;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Invalid type name: " + vmTypeName);
                }
            }
        }
        for (int off = 0; off < this.getIdentifier().length(); ++off) {
            char c = this.getIdentifier().charAt(off);
            if (c == '-' || c == '[' || c == '/' || c == '<' || c == '>' || Character.isJavaIdentifierPart(c)) {
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Cannot parse '" + vmTypeName + "' as vm type name.");
        }
    }

    static {
        Companion = new Companion(null);
        GENERICS_PATTERN = Pattern.compile("<[^<>]*>");
        Cache cache = CacheBuilder.newBuilder().weakValues().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder().weakValues().build()");
        index = cache;
        JAVA_LANG_BOOLEAN = Companion.of("Ljava/lang/Boolean");
        JAVA_LANG_STRING = Companion.of("Ljava/lang/String");
        JAVA_LANG_SYSTEM = Companion.of("Ljava/lang/System");
        JAVA_LANG_NULL_POINTER_EXCEPTION = Companion.of("Ljava/lang/NullPointerException");
        JAVA_LANG_EXCEPTION_IN_INITIALIZER_ERROR = Companion.of("Ljava/lang/ExceptionInInitializerError");
        OBJECT = Companion.of("Ljava/lang/Object");
        STRING = Companion.of("Ljava/lang/String");
        NULL = Companion.of("Lnull");
        ANY = Companion.of("Lany");
        ERASED = Companion.of("Lerased");
        BYTE = Companion.of("B");
        BOOLEAN = Companion.of("Z");
        CHAR = Companion.of("C");
        DOUBLE = Companion.of("D");
        FLOAT = Companion.of("F");
        INT = Companion.of("I");
        LONG = Companion.of("J");
        SHORT = Companion.of("S");
        VOID = Companion.of("V");
    }

    @Override
    public boolean eq(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ITypeName.DefaultImpls.eq(this, other);
    }

    @Override
    public boolean ne(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ITypeName.DefaultImpls.ne(this, other);
    }

    public /* synthetic */ VmTypeName(Object vmTypeName, DefaultConstructorMarker $constructor_marker) {
        this(vmTypeName);
    }

    @JvmStatic
    @JsonCreator
    @NotNull
    public static final synchronized VmTypeName of(@NotNull String identifier) {
        return Companion.of(identifier);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001cH\u0007J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/recommenders/java/commons/names/VmTypeName$Companion;", "", "()V", "ANY", "Lcom/jetbrains/recommenders/java/commons/names/VmTypeName;", "BOOLEAN", "BYTE", "CHAR", "DOUBLE", "ERASED", "FLOAT", "GENERICS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "INT", "JAVA_LANG_BOOLEAN", "JAVA_LANG_EXCEPTION_IN_INITIALIZER_ERROR", "JAVA_LANG_NULL_POINTER_EXCEPTION", "JAVA_LANG_STRING", "JAVA_LANG_SYSTEM", "LONG", "NULL", "OBJECT", "SHORT", "STRING", "VOID", "index", "Lcom/google/common/cache/Cache;", "", "of", "identifier", "removeGenerics", "recommenders-java-commons"})
    public static final class Companion {
        @JvmStatic
        @JsonCreator
        @NotNull
        public final synchronized VmTypeName of(@NotNull String identifier) {
            Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
            String typeName = this.removeGenerics(identifier);
            Object object = index.get((Object)typeName, (Callable)new Callable<VmTypeName>(typeName){
                final /* synthetic */ String $typeName;

                @NotNull
                public final VmTypeName call() {
                    return new VmTypeName(this.$typeName, null);
                }
                {
                    this.$typeName = string;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"index.get(typeName) { VmTypeName(typeName) }");
            return (VmTypeName)object;
        }

        private final String removeGenerics(String identifier) {
            String typeName = identifier;
            int oldLength = 0;
            do {
                oldLength = typeName.length();
                Matcher matcher = GENERICS_PATTERN.matcher(typeName);
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher.replaceAll(""), (String)"matcher.replaceAll(\"\")");
            } while (typeName.length() < oldLength);
            return typeName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

