/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.jpa;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.Props;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.persistence.integration.SpringXmlPersistencePackage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="SpringApiIcons.SpringConfig")
public class SpringXmlJpaPersistenceUnit
extends SpringXmlPersistencePackage {
    public SpringXmlJpaPersistenceUnit(DomSpringBeanPointer bean, Module module) {
        super(bean, module);
    }

    @Override
    @NotNull
    protected CachedValueProvider.Result<Properties> getPersistenceUnitPropertiesInner() {
        SpringPropertyDefinition hibernateProperties;
        SpringPropertyDefinition jpaPropertiesMap;
        Properties result = new Properties();
        SpringPropertyDefinition jpaProperties = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)"jpaProperties");
        if (jpaProperties instanceof SpringProperty) {
            SpringXmlJpaPersistenceUnit.collectProperties(result, (SpringProperty)jpaProperties);
        }
        if ((jpaPropertiesMap = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)"jpaPropertyMap")) instanceof SpringProperty) {
            SpringXmlJpaPersistenceUnit.collectProperties(result, (SpringProperty)jpaPropertiesMap);
        }
        if ((hibernateProperties = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)"hibernateProperties")) instanceof SpringProperty) {
            SpringXmlJpaPersistenceUnit.collectProperties(result, (SpringProperty)hibernateProperties);
        }
        Object[] dependencies = new Object[]{this.getContainingFile()};
        return new CachedValueProvider.Result((Object)result, dependencies);
    }

    private static void collectProperties(Properties result, SpringProperty p) {
        String key;
        Collection variants;
        Props props;
        if (DomUtil.hasXml((DomElement)p.getProps())) {
            props = p.getProps();
            for (Prop prop : props.getProps()) {
                variants = PlaceholderUtils.getInstance().getValueVariants((GenericDomValue)prop);
                key = (String)prop.getKey().getValue();
                if (key == null) continue;
                result.setProperty(key, variants.isEmpty() ? "" : (String)variants.iterator().next());
            }
        }
        if (DomUtil.hasXml((DomElement)p.getMap())) {
            props = p.getMap();
            for (SpringEntry entry : props.getEntries()) {
                variants = PlaceholderUtils.getInstance().getValueVariants((SpringValueHolderDefinition)entry);
                key = (String)ObjectUtils.chooseNotNull((Object)entry.getKeyAttr().getStringValue(), (Object)entry.getKey().getValueAsString());
                if (key == null) continue;
                result.setProperty(key, variants.isEmpty() ? "" : (String)variants.iterator().next());
            }
        }
    }

    @Override
    @Nullable
    public String getPersistenceProviderName() {
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)"persistenceProviderClass");
        GenericDomValue value = property == null ? null : SpringPropertyUtils.getPropertyDomValue((SpringValueHolderDefinition)property);
        return value == null ? null : value.getStringValue();
    }

    public GenericValue<Boolean> getExcludeUnlistedClasses() {
        return ReadOnlyGenericValue.getInstance((Object)Boolean.FALSE);
    }

    @Override
    @NotNull
    public List<? extends GenericValue<PsiPackage>> getPackages() {
        List<GenericValue<PsiPackage>> list = this.getPackagesToScan();
        if (list == null) {
            SpringXmlJpaPersistenceUnit.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public GenericValue<String> getDataSourceName() {
        SpringBeanPointer springBean;
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)"dataSource");
        if (property != null && (springBean = SpringPropertyUtils.findReferencedBean((SpringPropertyDefinition)property)) != null) {
            String name = springBean.getName();
            return StringUtil.isNotEmpty((String)name) ? ReadOnlyGenericValue.getInstance((Object)name) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/jpa/SpringXmlJpaPersistenceUnit", "getPackages"));
    }
}

