/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import icons.XsltDebuggerIcons;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.intellij.plugins.xsltDebugger.XsltDebuggerBundle;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.intellij.plugins.xsltDebugger.ui.GeneratedStructureModel;
import org.jetbrains.annotations.NotNull;

class GeneratedStructureRenderer
extends ColoredTreeCellRenderer {
    GeneratedStructureRenderer() {
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            GeneratedStructureRenderer.$$$reportNull$$$0(0);
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object o = node.getUserObject();
        this.setToolTipText(null);
        if (o != null && !"ROOT".equals(o)) {
            if (o instanceof String) {
                this.append((String)o, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                this.setToolTipText(XsltDebuggerBundle.message("tooltip.element.is.not.finished.yet", new Object[0]));
            } else if (o instanceof OutputEventQueue.NodeEvent) {
                OutputEventQueue.NodeEvent event = (OutputEventQueue.NodeEvent)o;
                OutputEventQueue.NodeEvent.QName qname = event.getQName();
                switch (event.getType()) {
                    case 1: {
                        this.setIcon(PlatformIcons.XML_TAG_ICON);
                        this.append(qname.getQName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        if (qname.myURI == null || qname.myURI.length() <= 0) break;
                        this.append(" {", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(qname.myURI, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("}", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        break;
                    }
                    case 3: {
                        this.setIcon(PlatformIcons.ANNOTATION_TYPE_ICON);
                        this.append(qname.getQName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        if (qname.myURI != null && qname.myURI.length() > 0) {
                            this.append(" {" + qname.myURI + "}", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        this.append(" = \"", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append(event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append("\"", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 4: {
                        this.append("#text ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(GeneratedStructureRenderer.clipValue(event.getValue()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 5: {
                        this.setIcon(XsltDebuggerIcons.XmlComment);
                        this.append("#comment ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 6: {
                        this.append("#processing-instruction ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(qname.myLocalName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.append(" " + event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 20: {
                        this.setIcon(AllIcons.Debugger.Db_set_breakpoint);
                        this.append(XsltDebuggerBundle.message("tracepoint.at.line.0", event.getLineNumber()), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        if (event.getValue() == null) break;
                        this.append(" " + event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                if (node instanceof GeneratedStructureModel.StructureNode && ((GeneratedStructureModel.StructureNode)node).isNew()) {
                    this.append(" *", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                }
            }
        }
    }

    @NlsSafe
    static String clipValue(String stringValue) {
        return stringValue.length() < 80 ? stringValue : stringValue.substring(0, 80) + "...";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/intellij/plugins/xsltDebugger/ui/GeneratedStructureRenderer", "customizeCellRenderer"));
    }
}

