/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SpringBootApplicationLifecycleManager {
    public static final Key<Integer> JMX_PORT = Key.create((String)"SPRING_BOOT_APPLICATION_JMX_PORT");

    public static SpringBootApplicationLifecycleManager getInstance(Project project) {
        return (SpringBootApplicationLifecycleManager)ServiceManager.getService((Project)project, SpringBootApplicationLifecycleManager.class);
    }

    public boolean isLifecycleManagementEnabled(@NotNull ProcessHandler var1);

    @Nullable
    public SpringBootApplicationInfo getSpringBootApplicationInfo(ProcessHandler var1);

    public List<SpringBootApplicationInfo> getSpringBootApplicationInfos();

    @Nullable
    public SpringBootApplicationDescriptor getSpringBootApplicationDescriptor(ProcessHandler var1);

    public List<SpringBootApplicationDescriptor> getRunningSpringBootApplications();

    public void addInfoListener(@NotNull InfoListener var1);

    public void removeInfoListener(@NotNull InfoListener var1);

    public static interface TunnelPortMapping {
        public static final Key<TunnelPortMapping> KEY = Key.create((String)"SPRING_BOOT_APPLICATION_TUNNEL_PORT_MAPPING");

        public int getLocalPort(int var1);
    }

    public static interface InfoListener {
        public void infoAdded(@NotNull ProcessHandler var1, @NotNull SpringBootApplicationInfo var2);

        public void infoRemoved(@NotNull ProcessHandler var1, @NotNull SpringBootApplicationInfo var2);
    }
}

