/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.reactor;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringBootReactorHooksOnDebugInspection
extends SpringUastInspectionBase {
    private static final String TRUE_VALUE = "true";
    private static final String REACTOR_DEBUG_AGENT_CONFIG_KEY = "spring.reactor.debug-agent.enabled";
    private static final String ON_OPERATOR_DEBUG_METHOD = "onOperatorDebug";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Module module;
        if (holder == null) {
            SpringBootReactorHooksOnDebugInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            SpringBootReactorHooksOnDebugInspection.$$$reportNull$$$0(1);
        }
        if (!this.isEnabledForModule(module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringBootReactorHooksOnDebugInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                PsiClass containingClass;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_2_0)) {
                    return;
                }
                if (!SpringBootReactorHooksOnDebugInspection.hasDebugAgent(module)) {
                    return;
                }
                UCallExpression callExpression = (UCallExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UCallExpression.class});
                if (callExpression == null) {
                    return;
                }
                String methodName = callExpression.getMethodName();
                if (methodName == null || !methodName.equals(SpringBootReactorHooksOnDebugInspection.ON_OPERATOR_DEBUG_METHOD)) {
                    return;
                }
                PsiMethod resolvedMethod = callExpression.resolve();
                PsiClass psiClass = containingClass = resolvedMethod != null ? resolvedMethod.getContainingClass() : null;
                if (containingClass == null || !"reactor.core.publisher.Hooks".equals(containingClass.getQualifiedName())) {
                    return;
                }
                SpringModel model = SpringManager.getInstance((Project)element.getProject()).getCombinedModel(module);
                String value = SpringBootConfigValueSearcher.productionForProfiles(module, SpringBootReactorHooksOnDebugInspection.REACTOR_DEBUG_AGENT_CONFIG_KEY, model.getActiveProfiles()).findValueText();
                if (value == null || SpringBootReactorHooksOnDebugInspection.TRUE_VALUE.equals(value.trim())) {
                    PsiElement psiIdentifier;
                    UIdentifier methodIdentifier = callExpression.getMethodIdentifier();
                    PsiElement psiElement = psiIdentifier = methodIdentifier != null ? methodIdentifier.getSourcePsi() : null;
                    if (psiIdentifier == null) {
                        return;
                    }
                    holder.registerProblem(psiIdentifier, SpringBootApiBundle.message("spring.boot.reactor.hooks.on.debug.inspection", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new RemoveHooksOnOperatorDebugQuickFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/reactor/SpringBootReactorHooksOnDebugInspection$1", "visitElement"));
            }
        };
    }

    private static boolean hasDebugAgent(@NotNull Module module) {
        if (module == null) {
            SpringBootReactorHooksOnDebugInspection.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{dumbService.getModificationTracker()});
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
            PsiClass psiClass = facade.findClass("reactor.tools.agent.ReactorDebugAgent", module.getModuleRuntimeScope(false));
            return CachedValueProvider.Result.create((Object)(psiClass != null ? 1 : 0), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/reactor/SpringBootReactorHooksOnDebugInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/reactor/SpringBootReactorHooksOnDebugInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasDebugAgent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveHooksOnOperatorDebugQuickFix
    extends PsiElementBaseIntentionAction
    implements LocalQuickFix {
        private RemoveHooksOnOperatorDebugQuickFix() {
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            UQualifiedReferenceExpression expressionToDelete;
            UIdentifier identifier;
            UCallExpression callExpression;
            if (project == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(1);
            }
            if ((callExpression = UastUtils.getUCallExpression((UElement)(identifier = (UIdentifier)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UIdentifier.class})), (int)3)) == null) {
                return;
            }
            UQualifiedReferenceExpression qualifiedReferenceExpression = UastUtils.getOutermostQualified((UExpression)callExpression);
            Object object = expressionToDelete = qualifiedReferenceExpression != null ? qualifiedReferenceExpression : callExpression;
            if (expressionToDelete.getSourcePsi() != null) {
                expressionToDelete.getSourcePsi().delete();
            }
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = SpringBootApiBundle.message("spring.boot.reactor.hooks.on.debug.quickfix", new Object[0]);
            if (string == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                RemoveHooksOnOperatorDebugQuickFix.$$$reportNull$$$0(7);
            }
            this.invoke(project, null, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/reactor/SpringBootReactorHooksOnDebugInspection$RemoveHooksOnOperatorDebugQuickFix";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/reactor/SpringBootReactorHooksOnDebugInspection$RemoveHooksOnOperatorDebugQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

