/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.options;

import com.intellij.DynamicBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTabConfigurable;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

class SpringBootSettingsUi
implements ConfigurableUi<SpringBootSettings> {
    private JPanel myRootPanel;
    private JBCheckBox myAdditionalConfigJsonShowPanel;
    private JBCheckBox myInitializrAutoCreateRunConfiguration;
    private JPanel myDashboardEndpointsPanel;
    private JBCheckBox myReformatAfterCreation;
    private final Project myProject;

    SpringBootSettingsUi(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull SpringBootSettings settings) {
        if (settings == null) {
            SpringBootSettingsUi.$$$reportNull$$$0(0);
        }
        this.myAdditionalConfigJsonShowPanel.setSelected(settings.isShowAdditionalConfigNotification());
        this.myInitializrAutoCreateRunConfiguration.setSelected(settings.isAutoCreateRunConfiguration());
        this.myReformatAfterCreation.setSelected(settings.isReformatAfterCreation());
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            tabConfigurable.reset();
        }
    }

    public boolean isModified(@NotNull SpringBootSettings settings) {
        if (settings == null) {
            SpringBootSettingsUi.$$$reportNull$$$0(1);
        }
        if (this.hasModifiedEditorSettings(settings)) {
            return true;
        }
        if (this.myInitializrAutoCreateRunConfiguration.isSelected() != settings.isAutoCreateRunConfiguration()) {
            return true;
        }
        if (this.myReformatAfterCreation.isSelected() != settings.isReformatAfterCreation()) {
            return true;
        }
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            if (!tabConfigurable.isModified()) continue;
            return true;
        }
        return false;
    }

    private boolean hasModifiedEditorSettings(@NotNull SpringBootSettings settings) {
        if (settings == null) {
            SpringBootSettingsUi.$$$reportNull$$$0(2);
        }
        return this.myAdditionalConfigJsonShowPanel.isSelected() != settings.isShowAdditionalConfigNotification();
    }

    public void apply(@NotNull SpringBootSettings settings) throws ConfigurationException {
        if (settings == null) {
            SpringBootSettingsUi.$$$reportNull$$$0(3);
        }
        if (this.hasModifiedEditorSettings(settings)) {
            settings.setShowAdditionalConfigNotification(this.myAdditionalConfigJsonShowPanel.isSelected());
            EditorNotifications.updateAll();
        }
        settings.setAutoCreateRunConfiguration(this.myInitializrAutoCreateRunConfiguration.isSelected());
        settings.setReformatAfterCreation(this.myReformatAfterCreation.isSelected());
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            tabConfigurable.apply();
        }
    }

    @NotNull
    public JComponent getComponent() {
        int row = 0;
        for (EndpointTabConfigurable tabConfigurable : this.getEndpointTabConfigurables()) {
            JComponent component = tabConfigurable.createComponent();
            assert (component instanceof JPanel) : tabConfigurable;
            JPanel panel = (JPanel)component;
            panel.setBorder(IdeBorderFactory.createTitledBorder((String)tabConfigurable.getDisplayName()));
            GridConstraints constraint = new GridConstraints();
            constraint.setRow(row++);
            constraint.setIndent(1);
            constraint.setAnchor(9);
            this.myDashboardEndpointsPanel.add((Component)component, constraint);
        }
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            SpringBootSettingsUi.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private EndpointTabConfigurable @NotNull [] getEndpointTabConfigurables() {
        EndpointTabConfigurable[] endpointTabConfigurableArray = (EndpointTabConfigurable[])EndpointTabConfigurable.EP_NAME.getExtensions((AreaInstance)this.myProject);
        if (endpointTabConfigurableArray == null) {
            SpringBootSettingsUi.$$$reportNull$$$0(5);
        }
        return endpointTabConfigurableArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/options/SpringBootSettingsUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/options/SpringBootSettingsUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointTabConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifiedEditorSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SpringBootApiBundle", SpringBootSettingsUi.class).getString("spring.boot.settings.configuration.metadata.files"), (int)1, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel3.getFont()), null));
        this.myAdditionalConfigJsonShowPanel = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/SpringBootApiBundle", SpringBootSettingsUi.class).getString("spring.boot.settings.show.notification.panel"));
        jBCheckBox3.setToolTipText(ResourceBundle.getBundle("messages/SpringBootApiBundle").getString("spring.boot.settings.show.notification.panel.tooltip"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDashboardEndpointsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SpringBootApiBundle", SpringBootSettingsUi.class).getString("spring.boot.settings.endpoints.tab"), (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Initializr", (int)0, (int)0, null, null));
        this.myInitializrAutoCreateRunConfiguration = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/SpringBootApiBundle", SpringBootSettingsUi.class).getString("spring.boot.settings.create.run.configuration"));
        jBCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/SpringBootApiBundle").getString("spring.boot.settings.create.run.configuration.tooltip"));
        jPanel4.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReformatAfterCreation = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SpringBootApiBundle", SpringBootSettingsUi.class).getString("spring.boot.settings.reformat.code"));
        jBCheckBox.setToolTipText(ResourceBundle.getBundle("messages/SpringBootApiBundle").getString("spring.boot.settings.reformat.code.tooltip"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 2, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

