/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConditionalOnEndpointBase
implements ConditionalOnJamElement {
    @NonNls
    protected static final String CONFIG_KEY_SUFFIX = ".enabled";

    ConditionalOnEndpointBase() {
    }

    @NotNull
    protected abstract JamStringAttributeElement<MetaConfigKey> getValueJam();

    protected abstract String getPrefix();

    protected String getSuffix() {
        return CONFIG_KEY_SUFFIX;
    }

    protected abstract String getConfigurationKey(String var1);

    @Override
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        String value = this.getValue();
        if (StringUtil.isEmpty((String)value)) {
            return ConditionOutcome.noMatch("Empty 'value' attribute");
        }
        String configKey = this.getConfigurationKey(value);
        Ref wrongValue = Ref.create();
        Processor isKeySetToTrue = results -> {
            if (ContainerUtil.exists((Iterable)results, result2 -> Comparing.strEqual((String)"true", (String)result2.getValueText(), (boolean)false))) {
                return false;
            }
            ConfigurationValueResult firstItem = (ConfigurationValueResult)ContainerUtil.getFirstItem((List)results);
            if (firstItem != null) {
                wrongValue.set((Object)firstItem.getValueText());
            }
            return true;
        };
        if (!context.processConfigurationValues((Processor<List<ConfigurationValueResult>>)isKeySetToTrue, true, configKey)) {
            return ConditionOutcome.match(ConditionMessage.foundConfigKeyWithValue(configKey, "true"));
        }
        if (!wrongValue.isNull()) {
            return ConditionOutcome.noMatch(ConditionMessage.foundConfigKeyWithValue(configKey, (String)wrongValue.get()));
        }
        String defaultsKey = this.getConfigurationKey("defaults");
        if (!context.processConfigurationValues((Processor<List<ConfigurationValueResult>>)isKeySetToTrue, true, defaultsKey)) {
            return ConditionOutcome.match(ConditionMessage.foundConfigKeyWithValue(defaultsKey, "true"));
        }
        if (!wrongValue.isNull()) {
            return ConditionOutcome.noMatch(ConditionMessage.foundConfigKeyWithValue(defaultsKey, (String)wrongValue.get()));
        }
        return ConditionOutcome.match(ConditionMessage.generic("Unset", "property", configKey, defaultsKey));
    }

    @Nullable
    public String getValue() {
        return this.getValueJam().getStringValue();
    }

    @Nullable
    public MetaConfigKey getResolvedConfigurationKey(@NotNull Module module) {
        if (module == null) {
            ConditionalOnEndpointBase.$$$reportNull$$$0(0);
        }
        PrefixSuffixApplicationMetaConfigKeyConverter converter = new PrefixSuffixApplicationMetaConfigKeyConverter(module, this.getPrefix(), this.getSuffix());
        return converter.fromString(this.getValue(), this.getValueJam());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnEndpointBase", "getResolvedConfigurationKey"));
    }

    protected static class PrefixSuffixApplicationMetaConfigKeyConverter
    extends JamSimpleReferenceConverter<MetaConfigKey> {
        private final Module myModule;
        private final String myConfigKeyPrefix;
        private final String myConfigKeySuffix;

        protected PrefixSuffixApplicationMetaConfigKeyConverter(String configKeyPrefix, String configKeySuffix) {
            this.myConfigKeyPrefix = configKeyPrefix;
            this.myConfigKeySuffix = configKeySuffix;
            this.myModule = null;
        }

        private PrefixSuffixApplicationMetaConfigKeyConverter(@NotNull Module module, String configKeyPrefix, String configKeySuffix) {
            if (module == null) {
                PrefixSuffixApplicationMetaConfigKeyConverter.$$$reportNull$$$0(0);
            }
            this.myModule = module;
            this.myConfigKeyPrefix = configKeyPrefix;
            this.myConfigKeySuffix = configKeySuffix;
        }

        public String getConfigurationKey(String value) {
            return this.myConfigKeyPrefix + value + this.myConfigKeySuffix;
        }

        @Nullable
        public MetaConfigKey fromString(@Nullable String s, JamStringAttributeElement<MetaConfigKey> context) {
            PsiAnnotationMemberValue psiElement = context.getPsiElement();
            assert (psiElement != null);
            Module module = (Module)ObjectUtils.chooseNotNull((Object)this.myModule, (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
            return SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(module, this.getConfigurationKey(s));
        }

        @Nullable
        protected PsiElement getPsiElementFor(@NotNull MetaConfigKey target) {
            if (target == null) {
                PrefixSuffixApplicationMetaConfigKeyConverter.$$$reportNull$$$0(1);
            }
            return target.getDeclaration();
        }

        @NotNull
        protected LookupElement createLookupElementFor(@NotNull MetaConfigKey target) {
            if (target == null) {
                PrefixSuffixApplicationMetaConfigKeyConverter.$$$reportNull$$$0(2);
            }
            String afterPrefix = StringUtil.substringAfter((String)target.getName(), (String)this.myConfigKeyPrefix);
            assert (afterPrefix != null);
            String id = StringUtil.substringBefore((String)afterPrefix, (String)this.myConfigKeySuffix);
            LookupElement lookupElement = target.getPresentation().tuneLookupElement((LookupElement)target.getPresentation().getLookupElement(id));
            if (lookupElement == null) {
                PrefixSuffixApplicationMetaConfigKeyConverter.$$$reportNull$$$0(3);
            }
            return lookupElement;
        }

        public Collection<MetaConfigKey> getVariants(JamStringAttributeElement<MetaConfigKey> context) {
            List<SpringBootApplicationMetaConfigKey> allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys((PsiElement)context.getPsiElement());
            SmartList variants = new SmartList();
            for (MetaConfigKey metaConfigKey : allKeys) {
                String name;
                if (!metaConfigKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL}) || !StringUtil.startsWith((CharSequence)(name = metaConfigKey.getName()), (CharSequence)this.myConfigKeyPrefix) || !StringUtil.endsWith((CharSequence)name, (CharSequence)this.myConfigKeySuffix)) continue;
                variants.add(metaConfigKey);
            }
            return variants;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnEndpointBase$PrefixSuffixApplicationMetaConfigKeyConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnEndpointBase$PrefixSuffixApplicationMetaConfigKeyConverter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElementFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPsiElementFor";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElementFor";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

