/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConditionalOnEnabledResourceChain
implements ConditionalOnJamElement {
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain");
    private static final SemKey<ConditionalOnEnabledResourceChain> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnEnabledResourceChain", new SemKey[0]);
    public static final JamClassMeta<ConditionalOnEnabledResourceChain> CLASS_META = new JamClassMeta(null, ConditionalOnEnabledResourceChain.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnEnabledResourceChain> METHOD_META = new JamMethodMeta(null, ConditionalOnEnabledResourceChain.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    @NonNls
    private static final String[] CONFIGURATION_KEYS = new String[]{"spring.resources.chain.enabled", "spring.resources.chain.strategy.fixed.enabled", "spring.resources.chain.strategy.content.enabled"};
    @NonNls
    private static final String WEB_JAR_ASSET_LOCATOR = "org.webjars.WebJarAssetLocator";
    private static final Key<ConditionOutcome> OUTCOME_KEY = Key.create((String)"ConditionalOnEnabledResourceChain");
    private static final Function<ConditionalOnEvaluationContext, ConditionOutcome> OUTCOME_FUNCTION = context -> {
        boolean hasWebJar;
        Processor isSetToTrueProcessor = results -> !ContainerUtil.exists((Iterable)results, result2 -> Comparing.strEqual((String)"true", (String)result2.getValueText(), (boolean)false));
        for (String key : CONFIGURATION_KEYS) {
            if (context.processConfigurationValues((Processor<List<ConfigurationValueResult>>)isSetToTrueProcessor, true, key)) continue;
            return ConditionOutcome.match(ConditionMessage.foundConfigKeyWithValue(key, "true"));
        }
        boolean bl = hasWebJar = SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_JAR_ASSET_LOCATOR) != null;
        if (hasWebJar) {
            return ConditionOutcome.match(ConditionMessage.foundClass(WEB_JAR_ASSET_LOCATOR));
        }
        return ConditionOutcome.noMatch(ConditionMessage.didNotFindClass(WEB_JAR_ASSET_LOCATOR));
    };

    @Override
    @NotNull
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        ConditionOutcome data = (ConditionOutcome)context.getUserData(OUTCOME_KEY);
        if (data == null) {
            data = (ConditionOutcome)context.putUserDataIfAbsent(OUTCOME_KEY, (ConditionOutcome)OUTCOME_FUNCTION.fun((Object)context));
        }
        ConditionOutcome conditionOutcome = data;
        if (conditionOutcome == null) {
            ConditionalOnEnabledResourceChain.$$$reportNull$$$0(0);
        }
        return conditionOutcome;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnEnabledResourceChain", "matches"));
    }
}

