/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassSorter;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigureMetadataIndex;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoConfigClassFilterService;
import java.util.ArrayList;
import java.util.List;

class SpringBootAutoConfigClassFilterServiceImpl
extends SpringBootAutoConfigClassFilterService {
    SpringBootAutoConfigClassFilterServiceImpl() {
    }

    @Override
    public List<PsiClass> filterByConditionalOnClass(Module module, List<PsiClass> configs) {
        GlobalSearchScope searchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        ArrayList<PsiClass> enabled = new ArrayList<PsiClass>(configs.size() / 2);
        for (PsiClass config : configs) {
            AutoConfigureMetadataIndex.AutoConfigureMetadata metadata = AutoConfigureMetadataIndex.findMetadata(config);
            if (metadata != null) {
                boolean foundAll = true;
                for (String conditionalClass : metadata.getConditionalOnClass()) {
                    PsiClass aClass = javaPsiFacade.findClass(conditionalClass, searchScope);
                    if (aClass != null) continue;
                    foundAll = false;
                    break;
                }
                if (!foundAll) continue;
                enabled.add(config);
                continue;
            }
            if (!AutoConfigClassSorter.passesConditionalClassMatch(config)) continue;
            enabled.add(config);
        }
        return enabled;
    }
}

