/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.facet.SpringBootFileSetEditorCustomization;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigLocalAnnotationModel;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoConfigDependentModelsProvider
extends LocalAnnotationModelDependentModelsProvider {
    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel, ? super LocalModelDependency> processor2) {
        if (!this.acceptModel(localAnnotationModel)) {
            return true;
        }
        for (Pair<LocalModel, LocalModelDependency> pair : this.getAutoConfigModels(localAnnotationModel)) {
            if (processor2.process(pair.getFirst(), pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptModel(@NotNull LocalAnnotationModel model) {
        if (model == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(0);
        }
        return AbstractAutoConfigDependentModelsProvider.isSpringBootConfigured(model.getModule());
    }

    @NotNull
    private Set<Pair<LocalModel, LocalModelDependency>> getAutoConfigModels(@NotNull LocalAnnotationModel localAnnotationModel) {
        if (localAnnotationModel == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(1);
        }
        Module module = localAnnotationModel.getModule();
        assert (module != null);
        boolean nonStrictEvaluation = AbstractAutoConfigDependentModelsProvider.isNonStrictEvaluation(module);
        Map<SpringBootModelConfigFileContributor, List<VirtualFile>> configFilesCache = AbstractAutoConfigDependentModelsProvider.createConfigFilesCache(module);
        LinkedHashSet<Pair<LocalModel, LocalModelDependency>> autoConfigModels = new LinkedHashSet<Pair<LocalModel, LocalModelDependency>>();
        ConditionalOnEvaluationContext sharedContext = AbstractAutoConfigDependentModelsProvider.createContext(localAnnotationModel.getConfig(), module, localAnnotationModel.getActiveProfiles(), configFilesCache, null);
        List<PsiClass> autoConfigClasses = this.getAutoConfigClasses(localAnnotationModel, sharedContext);
        for (PsiClass autoConfigClass : autoConfigClasses) {
            sharedContext = this.processConfigurationClass(autoConfigModels, autoConfigClass, nonStrictEvaluation, sharedContext, module, localAnnotationModel.getActiveProfiles(), configFilesCache);
        }
        LinkedHashSet<Pair<LocalModel, LocalModelDependency>> linkedHashSet = autoConfigModels;
        if (linkedHashSet == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    protected abstract List<PsiClass> getAutoConfigClasses(@NotNull LocalAnnotationModel var1, @NotNull ConditionalOnEvaluationContext var2);

    private static ConditionalOnEvaluationContext createContext(@NotNull PsiClass psiClass, @NotNull Module module, @NotNull Set<String> activeProfiles, @NotNull Map<SpringBootModelConfigFileContributor, List<VirtualFile>> configFilesCache, @Nullable ConditionalOnEvaluationContext sharedContext) {
        if (psiClass == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(4);
        }
        if (activeProfiles == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(5);
        }
        if (configFilesCache == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(6);
        }
        ConditionalOnEvaluationContextBase useSharedContext = sharedContext instanceof ConditionalOnEvaluationContextBase ? (ConditionalOnEvaluationContextBase)sharedContext : null;
        return new ConditionalOnEvaluationContextBase(psiClass, module, activeProfiles, configFilesCache, useSharedContext);
    }

    private static Map<SpringBootModelConfigFileContributor, List<VirtualFile>> createConfigFilesCache(Module module) {
        return ConcurrentFactoryMap.createMap(contributor -> {
            SmartList configFiles = new SmartList();
            for (SpringBootModelConfigFileNameContributor nameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
                if (!nameContributor.accept(module)) continue;
                List<VirtualFile> files = contributor.getConfigurationFiles(module, nameContributor, false);
                configFiles.addAll(files);
            }
            return configFiles;
        });
    }

    private static boolean isNonStrictEvaluation(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(7);
        }
        CustomSetting.BOOLEAN setting = (springFacet = SpringFacet.getInstance((Module)module)) != null ? (CustomSetting.BOOLEAN)springFacet.findSetting(SpringBootFileSetEditorCustomization.NON_STRICT_SETTING) : null;
        return setting == null || setting.getBooleanValue();
    }

    @NotNull
    private ConditionalOnEvaluationContext processConfigurationClass(@NotNull Set<Pair<LocalModel, LocalModelDependency>> autoConfigModels, @NotNull PsiClass autoConfigClass, boolean nonStrictEvaluation, @Nullable ConditionalOnEvaluationContext sharedContext, @NotNull Module module, @NotNull Set<String> activeProfiles, @NotNull Map<SpringBootModelConfigFileContributor, List<VirtualFile>> configFilesCache) {
        if (autoConfigModels == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(8);
        }
        if (autoConfigClass == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(9);
        }
        if (module == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(10);
        }
        if (activeProfiles == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(11);
        }
        if (configFilesCache == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(12);
        }
        ProgressManager.checkCanceled();
        ConditionalOnEvaluationContext context = AbstractAutoConfigDependentModelsProvider.createContext(autoConfigClass, module, activeProfiles, configFilesCache, sharedContext);
        AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(autoConfigClass, nonStrictEvaluation, context);
        if (!evaluator.isActive()) {
            ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
            if (conditionalOnEvaluationContext == null) {
                AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(13);
            }
            return conditionalOnEvaluationContext;
        }
        AutoConfigLocalAnnotationModel autoConfigModel = new AutoConfigLocalAnnotationModel(autoConfigClass, module, activeProfiles, nonStrictEvaluation, sharedContext);
        LocalModelDependency dependency = LocalModelDependency.create((String)("Auto-configuration @" + autoConfigClass.getQualifiedName()), (LocalModelDependencyType)this.getModelDependencyType(), (PsiElement)autoConfigClass.getNavigationElement());
        autoConfigModels.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)((Object)autoConfigModel), (Object)dependency));
        for (PsiClass innerConfig : autoConfigClass.getInnerClasses()) {
            if (!innerConfig.hasModifierProperty("static") || JamService.getJamService((Project)module.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)innerConfig) == null) continue;
            this.processConfigurationClass(autoConfigModels, innerConfig, nonStrictEvaluation, context, module, activeProfiles, configFilesCache);
        }
        ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
        if (conditionalOnEvaluationContext == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(14);
        }
        return conditionalOnEvaluationContext;
    }

    protected abstract LocalModelDependencyType getModelDependencyType();

    protected static boolean isSpringBootConfigured(Module module) {
        return SpringCommonUtils.hasSpringFacet((Module)module) && SpringBootLibraryUtil.hasSpringBootLibrary(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAnnotationModel";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/AbstractAutoConfigDependentModelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilesCache";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoConfigModels";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoConfigClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/AbstractAutoConfigDependentModelsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigModels";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processConfigurationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfigModels";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNonStrictEvaluation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

