/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.facet.searchers.ConfigSearcherScopeModifier;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootAutoConfigureConfigSearcherScopeModifier
extends ConfigSearcherScopeModifier {
    @NotNull
    public GlobalSearchScope modifyScope(@NotNull Module module, @NotNull GlobalSearchScope originalScope) {
        if (module == null) {
            SpringBootAutoConfigureConfigSearcherScopeModifier.$$$reportNull$$$0(0);
        }
        if (originalScope == null) {
            SpringBootAutoConfigureConfigSearcherScopeModifier.$$$reportNull$$$0(1);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) {
            GlobalSearchScope globalSearchScope = originalScope;
            if (globalSearchScope == null) {
                SpringBootAutoConfigureConfigSearcherScopeModifier.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        List autoConfigs = SpringSpiManager.getInstance((Module)module).getClassesListValue(true, "org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        if (autoConfigs.isEmpty()) {
            GlobalSearchScope globalSearchScope = originalScope;
            if (globalSearchScope == null) {
                SpringBootAutoConfigureConfigSearcherScopeModifier.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        HashSet<VirtualFile> allConfigFiles = new HashSet<VirtualFile>(autoConfigs.size());
        for (PsiClass psiClass : autoConfigs) {
            SpringBootAutoConfigureConfigSearcherScopeModifier.processPsiClass(allConfigFiles, psiClass);
        }
        GlobalSearchScope configFilesScope = GlobalSearchScope.filesScope((Project)module.getProject(), allConfigFiles);
        GlobalSearchScope globalSearchScope = originalScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)configFilesScope));
        if (globalSearchScope == null) {
            SpringBootAutoConfigureConfigSearcherScopeModifier.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    private static void processPsiClass(Set<VirtualFile> allConfigFiles, PsiClass psiClass) {
        SpringConfiguration springConfiguration = (SpringConfiguration)SpringConfiguration.META.getJamElement((PsiModifierListOwner)psiClass);
        if (springConfiguration == null) {
            return;
        }
        SmartList allPsiClasses = new SmartList((Object)psiClass);
        SpringBootAutoConfigureConfigSearcherScopeModifier.addImports((List<PsiClass>)allPsiClasses, psiClass);
        SpringBootAutoConfigureConfigSearcherScopeModifier.addXmlImports(allConfigFiles, psiClass);
        SpringJamUtils.getInstance().processCustomAnnotations(psiClass, arg_0 -> SpringBootAutoConfigureConfigSearcherScopeModifier.lambda$processPsiClass$0((List)allPsiClasses, allConfigFiles, arg_0));
        allConfigFiles.addAll(ContainerUtil.map((Collection)allPsiClasses, psiClass1 -> psiClass1.getContainingFile().getVirtualFile()));
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static")) continue;
            SpringBootAutoConfigureConfigSearcherScopeModifier.processPsiClass(allConfigFiles, innerClass);
        }
    }

    private static void addXmlImports(Set<VirtualFile> configFiles, PsiClass psiClass) {
        Set xmlConfigs = SpringJamUtils.getInstance().getImportedResources(psiClass, new Module[0]);
        configFiles.addAll(ContainerUtil.map((Collection)xmlConfigs, PsiFile::getVirtualFile));
    }

    private static void addImports(List<PsiClass> allPsiClasses, PsiClass psiClass) {
        Set importedClasses = SpringJamUtils.getInstance().getImportedClasses(psiClass, null);
        allPsiClasses.addAll(importedClasses);
    }

    private static /* synthetic */ boolean lambda$processPsiClass$0(List allPsiClasses, Set allConfigFiles, Pair pair) {
        PsiClass enableAnno = (PsiClass)pair.first;
        SpringBootAutoConfigureConfigSearcherScopeModifier.addImports(allPsiClasses, enableAnno);
        SpringBootAutoConfigureConfigSearcherScopeModifier.addXmlImports(allConfigFiles, enableAnno);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/facet/SpringBootAutoConfigureConfigSearcherScopeModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/facet/SpringBootAutoConfigureConfigSearcherScopeModifier";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modifyScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

