/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.boot.banner.AnsiColor;
import com.intellij.spring.boot.banner.AnsiStyle;
import com.intellij.spring.boot.banner.BuiltinProperty;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootBannerPropertyReference
extends PsiReferenceBase.Poly<PsiElement> {
    private final boolean myBoot13;

    SpringBootBannerPropertyReference(PsiElement element, TextRange range, boolean isSpringBoot13) {
        super(element, range, true);
        this.myBoot13 = isSpringBoot13;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] dummyResult = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
        if (!this.myBoot13) {
            if (dummyResult == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(0);
            }
            return dummyResult;
        }
        String value = this.getValue();
        for (BuiltinProperty property : BuiltinProperty.values()) {
            if (!property.getPropertyName().equals(value)) continue;
            if (dummyResult == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(1);
            }
            return dummyResult;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiColor.")) {
            return this.resolveAnsiColor(value, "AnsiColor.", "org.springframework.boot.ansi.AnsiColor");
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiBackground.")) {
            return this.resolveAnsiColor(value, "AnsiBackground.", "org.springframework.boot.ansi.AnsiBackground");
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiStyle.")) {
            return this.resolveAnsiStyle(value, "AnsiStyle.");
        }
        List<MetaConfigKeyReference<?>> references = this.resolveConfigValue(value);
        if (references != null) {
            List targets = ContainerUtil.map(references, MetaConfigKeyReference::createNavigationElement);
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)targets);
            if (resolveResultArray == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (dummyResult == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(3);
        }
        return dummyResult;
    }

    @Nullable
    private List<MetaConfigKeyReference<?>> resolveConfigValue(String value) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return null;
        }
        SmartList results = new SmartList();
        SpringBootConfigValueSearcher.productionForProfiles(module, value, null).process((Processor<ConfigurationValueResult>)((Processor)arg_0 -> SpringBootBannerPropertyReference.lambda$resolveConfigValue$0((List)results, arg_0)));
        return results.isEmpty() ? null : results;
    }

    private ResolveResult @NotNull [] resolveAnsiColor(String value, String prefix, String className) {
        String name = StringUtil.substringAfter((String)value, (String)prefix);
        AnsiColor ansiColor = AnsiColor.findByName(name);
        if (ansiColor == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.findFieldInClass(className, name)});
        if (resolveResultArray == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private ResolveResult @NotNull [] resolveAnsiStyle(String value, String prefix) {
        String name = StringUtil.substringAfter((String)value, (String)prefix);
        AnsiStyle ansiStyle = AnsiStyle.findByName(name);
        if (ansiStyle == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringBootBannerPropertyReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.findFieldInClass("org.springframework.boot.ansi.AnsiStyle", name)});
        if (resolveResultArray == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @Nullable
    private PsiField findFieldInClass(String className, String fieldName) {
        PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), (String)className);
        return psiClass != null ? psiClass.findFieldByName(fieldName, false) : null;
    }

    public Object @NotNull [] getVariants() {
        if (EMPTY_ARRAY == null) {
            SpringBootBannerPropertyReference.$$$reportNull$$$0(8);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ boolean lambda$resolveConfigValue$0(List results, ConfigurationValueResult result2) {
        ContainerUtil.addIfNotNull((Collection)results, result2.getMetaConfigKeyReference());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnsiColor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnsiStyle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

