/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelApplicationPropertiesConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationPropertiesConfigFileContributor() {
        super((FileType)PropertiesFileType.INSTANCE);
    }

    @Override
    @NotNull
    public List<ConfigurationValueResult> findConfigurationValues(ConfigurationValueSearchParams params) {
        PropertiesFile propertiesFile = (PropertiesFile)ObjectUtils.tryCast((Object)params.getConfigFile(), PropertiesFile.class);
        if (propertiesFile == null) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (!SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevant(params, profileSuffix)) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList results = new SmartList();
        List<List<IProperty>> documents = SpringBootModelApplicationPropertiesConfigFileContributor.getDocuments(propertiesFile, params.getModule());
        boolean processAllDocuments = params.isProcessAllProfiles();
        for (List<IProperty> document : documents) {
            if (!processAllDocuments && !SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantDocument(document, params, profileSuffix) || SpringBootModelApplicationPropertiesConfigFileContributor.processDocument(document, params, (List<ConfigurationValueResult>)results) || processAllDocuments) continue;
            break;
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static List<List<IProperty>> getDocuments(PropertiesFile propertiesFile, Module module) {
        if (SpringBootApplicationPropertiesUtil.isSupportMultiDocuments(module)) {
            return SpringBootApplicationPropertiesUtil.getDocuments(propertiesFile);
        }
        return new SmartList((Object)propertiesFile.getProperties());
    }

    private static boolean processDocument(List<IProperty> document, ConfigurationValueSearchParams params, List<ConfigurationValueResult> results) {
        MetaConfigKey configKey = params.getConfigKey();
        String keyName = configKey.getName();
        if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL, MetaConfigKey.AccessType.INDEXED})) {
            IProperty byExactName = null;
            for (IProperty property : document) {
                if (!keyName.equals(property.getKey())) continue;
                byExactName = property;
                break;
            }
            if (byExactName != null) {
                results.add(SpringBootModelApplicationPropertiesConfigFileContributor.createResult(params, byExactName, null));
                return false;
            }
            if (!params.getCheckRelaxedNames() && configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
                return true;
            }
        }
        MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        boolean multipleOccurrencesPossible = configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.ENUM_MAP, MetaConfigKey.AccessType.MAP, MetaConfigKey.AccessType.INDEXED});
        boolean processParts = multipleOccurrencesPossible && (params.getKeyIndex() != null || params.getKeyProperty() != null);
        boolean found = false;
        for (IProperty property : document) {
            ProgressManager.checkCanceled();
            String propertyName = property.getName();
            if (propertyName == null || !params.getCheckRelaxedNames() && !propertyName.startsWith(keyName)) continue;
            if (processParts) {
                String keyIndexText = binder.bindsToKeyProperty(configKey, params.getKeyProperty(), propertyName);
                if (keyIndexText == null || params.getKeyIndex() != null && !keyIndexText.equals(params.getKeyIndex())) continue;
                results.add(SpringBootModelApplicationPropertiesConfigFileContributor.createResult(params, property, keyIndexText));
                found = true;
                continue;
            }
            if (!binder.bindsTo(configKey, propertyName)) continue;
            results.add(SpringBootModelApplicationPropertiesConfigFileContributor.createResult(params, property, null));
            if (!multipleOccurrencesPossible) {
                return false;
            }
            found = true;
        }
        return !found;
    }

    @NotNull
    private static ConfigurationValueResult createResult(@NotNull ConfigurationValueSearchParams params, @NotNull IProperty property, @Nullable String keyIndexText) {
        if (params == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(3);
        }
        if (property == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(4);
        }
        PropertyImpl propertyImpl = (PropertyImpl)property.getPsiElement();
        PropertyKeyImpl key = SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl);
        assert (key != null);
        return new ConfigurationValueResult((PsiElement)key, keyIndexText, (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl), propertyImpl.getValue(), params);
    }

    private static boolean isProfileRelevantDocument(List<IProperty> document, ConfigurationValueSearchParams params, String fileProfile) {
        Set<String> activeProfiles = params.getActiveProfiles();
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return true;
        }
        MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        return SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantByKey("spring.profiles", document, activeProfiles, null, binder) || SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantByKey("spring.config.activate.on-profile", document, activeProfiles, fileProfile, binder);
    }

    private static boolean isProfileRelevantByKey(String key, List<IProperty> document, Set<String> activeProfiles, String fileProfile, MetaConfigKeyManager.ConfigKeyNameBinder binder) {
        String profileText = fileProfile;
        for (IProperty property : document) {
            String propertyKey = property.getKey();
            if (propertyKey == null || !binder.matchesPart(key, propertyKey)) continue;
            profileText = property.getValue();
            break;
        }
        if (profileText == null) {
            return false;
        }
        try {
            Predicate profiles = SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)StringUtil.split((String)profileText, (String)","));
            return profiles.test(activeProfiles);
        }
        catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationValues";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

