/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.DuplicatePropertyKeyAnnotationSuppressor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBootDuplicatePropertyKeyAnnotationSuppressor
implements DuplicatePropertyKeyAnnotationSuppressor {
    public boolean suppressAnnotationFor(@NotNull Property property) {
        String key;
        if (property == null) {
            SpringBootDuplicatePropertyKeyAnnotationSuppressor.$$$reportNull$$$0(0);
        }
        if ((key = property.getKey()) == null) {
            return false;
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)property.getProject()) || !SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(property.getContainingFile())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property);
        if (!SpringBootApplicationPropertiesUtil.isSupportMultiDocuments(module)) {
            return false;
        }
        List<IProperty> document = SpringBootApplicationPropertiesUtil.getDocument(property);
        for (IProperty other : document) {
            if (property == other || !key.equals(other.getKey())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/boot/application/properties/SpringBootDuplicatePropertyKeyAnnotationSuppressor", "suppressAnnotationFor"));
    }
}

