/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationPropertiesUtil {
    private static final String DOCUMENT_SEPARATOR = "#---";

    SpringBootApplicationPropertiesUtil() {
    }

    @Nullable
    static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }

    @Nullable
    static PropertyValueImpl getPropertyValue(PropertyImpl property) {
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }

    static boolean isSupportMultiDocuments(Module module) {
        return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_4_0);
    }

    static List<IProperty> getDocument(Property anchor) {
        SmartList result2 = new SmartList();
        SmartList before = new SmartList();
        PsiElement element = anchor.getPrevSibling();
        while (element != null) {
            PsiElement prev = element.getPrevSibling();
            if (element instanceof Property) {
                before.add((Property)element);
            } else if (SpringBootApplicationPropertiesUtil.isDocumentSeparator(element, prev)) break;
            element = prev;
        }
        result2.addAll(ContainerUtil.reverse((List)before));
        SpringBootApplicationPropertiesUtil.collectDocument(anchor, (List<IProperty>)result2);
        return result2;
    }

    static List<List<IProperty>> getDocuments(PropertiesFile file) {
        Property property = (Property)ContainerUtil.getFirstItem((List)file.getProperties());
        if (property == null) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        while (property != null) {
            SmartList document = new SmartList();
            property = SpringBootApplicationPropertiesUtil.collectDocument(property, (List<IProperty>)document);
            result2.add(document);
        }
        return result2;
    }

    private static Property collectDocument(Property property, List<IProperty> document) {
        document.add((IProperty)property);
        Property current = property;
        PsiElement next = current.getNextSibling();
        while (next != null) {
            if (next instanceof Property) {
                document.add((IProperty)((Property)next));
            } else if (SpringBootApplicationPropertiesUtil.isDocumentSeparator(next, (PsiElement)current)) break;
            current = next;
            next = current.getNextSibling();
        }
        while (next != null) {
            if (!((next = next.getNextSibling()) instanceof Property)) continue;
            return (Property)next;
        }
        return null;
    }

    private static boolean isDocumentSeparator(PsiElement candidate, PsiElement prevSibling) {
        return candidate instanceof PsiComment && candidate.getText().trim().equals(DOCUMENT_SEPARATOR) && StringUtil.convertLineSeparators((String)prevSibling.getText()).equals("\n");
    }
}

