/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesCompletionContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationPropertiesPlaceholderReference
extends SpringBootPlaceholderReference {
    SpringBootApplicationPropertiesPlaceholderReference(PsiElement element, TextRange range) {
        super(element, range);
    }

    @Override
    @Nullable
    protected PsiElement resolveExistingKey(String key) {
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile == null) {
            return null;
        }
        IProperty property = propertiesFile.findPropertyByKey(key);
        return property != null ? property.getPsiElement() : null;
    }

    @Override
    protected void addExistingKeyVariants(List<LookupElement> result2) {
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile == null) {
            return;
        }
        for (IProperty property : propertiesFile.getProperties()) {
            ContainerUtil.addIfNotNull(result2, (Object)PropertiesCompletionContributor.createVariant((IProperty)property));
        }
    }

    @Nullable
    private PropertiesFile getPropertiesFile() {
        PsiFile file = this.getElement().getContainingFile();
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        return (PropertiesFile)file;
    }
}

