/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.microservices.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.config.SpringBootConfigFileHighlightingUtil;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenStorage;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesInspection
extends LocalInspectionTool {
    @NonNls
    public String replacementTokens = "@";
    final SpringBootReplacementTokenStorage myReplacementTokenStorage = new SpringBootReplacementTokenStorage();

    public SpringBootApplicationPropertiesInspection() {
        this.myReplacementTokenStorage.deserialize(this.replacementTokens);
    }

    public List<Couple<String>> getReplacementTokens() {
        return this.myReplacementTokenStorage.getReplacementTokens();
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringBootApplicationPropertiesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootApplicationPropertiesInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!SpringCommonUtils.hasSpringFacets((Project)manager.getProject()) || !SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(file)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        SpringBootConfigFileHighlightingUtil configFileHighlightingUtil = new SpringBootConfigFileHighlightingUtil(holder);
        for (IProperty iProperty : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            PsiReference[] keyParts;
            PropertyImpl property;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(iProperty instanceof PropertyImpl) || (propertyKey = SpringBootApplicationPropertiesUtil.getPropertyKey(property = (PropertyImpl)iProperty)) == null) continue;
            MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
            if (configKey == null) {
                String keyName = property.getName();
                configFileHighlightingUtil.highlightUnresolvedConfigKey((PsiElement)propertyKey, keyName);
                continue;
            }
            if (configKey.getDeprecation() != MetaConfigKey.Deprecation.NOT_DEPRECATED) {
                configFileHighlightingUtil.highlightDeprecatedConfigKey((PsiElement)propertyKey, configKey, SpringBootApplicationPropertiesInspection.getDeprecationFix(property, configKey));
            }
            if (configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP) && ((keyParts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)propertyKey.getText(), (boolean)false)) == null || keyParts.getKeyIndex() == null)) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message("application.config.missing.map.key", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            SpringBootApplicationPropertiesInspection.highlightIndexAccessExpressions(holder, propertyKey, configKey);
            if (MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
                keyParts = propertyKey.getReferences();
                int n = keyParts.length;
                for (int i = 0; i < n; ++i) {
                    PsiReference reference = keyParts[i];
                    if (!(reference instanceof ConfigKeyPathReference) || reference.isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if ((valueElement = SpringBootApplicationPropertiesUtil.getPropertyValue(property)) == null) continue;
            MicroservicesConfigUtils.highlightValueReferences((PsiElement)valueElement, (ProblemsHolder)holder);
        }
        return holder.getResultsArray();
    }

    private static void highlightIndexAccessExpressions(final ProblemsHolder holder, final PropertyKeyImpl propertyKey, MetaConfigKey configKey) {
        new IndexAccessTextProcessor(propertyKey.getText(), configKey){

            protected void onMissingClosingBracket(int startIdx) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message("application.config.missing.closing.bracket", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)1), new LocalQuickFix[0]);
            }

            protected void onMissingIndexValue(int startIdx) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message("application.config.missing.index.value", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)2), new LocalQuickFix[0]);
            }

            protected void onBracket(int startIdx) {
            }

            protected void onIndexValue(TextRange indexValueRange) {
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
                holder.registerProblem((PsiElement)propertyKey, SpringBootApiBundle.message("application.config.non.integer.index", new Object[0]), ProblemHighlightType.ERROR, indexValueRange, new LocalQuickFix[0]);
            }
        }.process();
    }

    private static LocalQuickFix[] getDeprecationFix(PropertyImpl property, final MetaConfigKey configKey) {
        final String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFixAndIntentionActionOnPsiElement((PsiElement)property){

            @NotNull
            public String getText() {
                String string = SpringBootApiBundle.message("application.config.replacement.quick.fix", replacement);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (startElement == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (endElement == null) {
                    2.$$$reportNull$$$0(4);
                }
                PropertyImpl property = (PropertyImpl)startElement;
                if (configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
                    PropertyKeyImpl propertyKey = SpringBootApplicationPropertiesUtil.getPropertyKey(property);
                    assert (propertyKey != null);
                    MetaConfigKeyReference reference = (MetaConfigKeyReference)ContainerUtil.findInstance((Object[])propertyKey.getReferences(), MetaConfigKeyReference.class);
                    assert (reference != null);
                    String originalKeyText = property.getKey();
                    assert (originalKeyText != null);
                    String originalMapKey = originalKeyText.substring(reference.getRangeInElement().getEndOffset());
                    property.setName(replacement + originalMapKey);
                } else {
                    property.setName(replacement);
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property);
                MetaConfigKey replacementMetaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, property.getKey());
                if (replacementMetaConfigKey != null && replacementMetaConfigKey.getType() != null && configKey.getType() != null && !configKey.getType().isAssignableFrom(replacementMetaConfigKey.getType())) {
                    PropertyValueImpl value = SpringBootApplicationPropertiesUtil.getPropertyValue(property);
                    if (value == null) {
                        return;
                    }
                    if (editor == null) {
                        property.setValue("");
                        return;
                    }
                    editor.getCaretModel().moveToOffset(value.getTextOffset());
                    property.setValue("");
                    AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                }
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = SpringBootApiBundle.message("application.config.replacement.quick.fix.family.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }};
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SpringBootApplicationPropertiesInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        this.myReplacementTokenStorage.deserialize(this.replacementTokens);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SpringBootApplicationPropertiesInspection.$$$reportNull$$$0(3);
        }
        this.replacementTokens = this.myReplacementTokenStorage.serialize();
        super.writeSettings(element);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm(SpringBootApiBundle.message("spring.boot.replacement.token.column.name", new Object[0]), this.myReplacementTokenStorage.getTokens());
        return FormBuilder.createFormBuilder().addComponentFillVertically(form.getContentPanel(), 0).getPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

