/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.microservices.config.ConfigKeyDocumentationProviderBase;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyImpl;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootConfigurationMetadataParser {
    private static final Logger LOG = Logger.getInstance(SpringBootConfigurationMetadataParser.class);
    @Nullable
    private final Module myLocalModule;
    @Nullable
    private final JsonFile myJsonPsiFile;
    @Nullable
    private final File myLocalJsonFile;
    private final String myLibraryName;
    private final Caching myCaching;
    private final NotNullLazyValue<Map<String, PsiElement>> myAdditionalConfigTargets;
    private static final Pair<PsiType, MetaConfigKey.AccessType> DUMMY_TYPE = Pair.create((Object)PsiType.NULL, (Object)MetaConfigKey.AccessType.NORMAL);

    SpringBootConfigurationMetadataParser(@NotNull JsonFile jsonPsiFile) {
        if (jsonPsiFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(0);
        }
        this.myAdditionalConfigTargets = new NotNullLazyValue<Map<String, PsiElement>>(){

            @NotNull
            protected Map<String, PsiElement> compute() {
                if (SpringBootConfigurationMetadataParser.this.myLocalModule == null) {
                    Map<String, PsiElement> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map2;
                }
                HashMap<String, PsiElement> additionalConfigTargets = new HashMap<String, PsiElement>();
                SpringBootAdditionalConfigUtils utils = new SpringBootAdditionalConfigUtils(SpringBootConfigurationMetadataParser.this.myLocalModule);
                utils.processAdditionalMetadataFiles((Processor<JsonFile>)((Processor)file -> {
                    com.intellij.json.psi.JsonObject rootObject = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), com.intellij.json.psi.JsonObject.class);
                    if (rootObject == null) {
                        return true;
                    }
                    JsonProperty propertiesRoot = rootObject.findProperty("properties");
                    if (propertiesRoot == null) {
                        return true;
                    }
                    JsonArray propertiesArray = (JsonArray)ObjectUtils.tryCast((Object)propertiesRoot.getValue(), JsonArray.class);
                    if (propertiesArray == null) {
                        return true;
                    }
                    for (JsonValue value : propertiesArray.getValueList()) {
                        String key;
                        JsonStringLiteral nameValue;
                        JsonProperty nameProperty;
                        com.intellij.json.psi.JsonObject object = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)value, com.intellij.json.psi.JsonObject.class);
                        if (object == null || (nameProperty = object.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.isNotEmpty((String)(key = nameValue.getValue()))) continue;
                        additionalConfigTargets.put(key, (PsiElement)nameProperty);
                    }
                    return true;
                }));
                HashMap<String, PsiElement> hashMap = additionalConfigTargets;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser$1", "compute"));
            }
        };
        this.myJsonPsiFile = jsonPsiFile;
        this.myLocalJsonFile = null;
        this.myLocalModule = null;
        this.myLibraryName = SpringBootConfigurationMetadataParser.getLibraryOrContainingJarName(jsonPsiFile);
        this.myCaching = new Caching(jsonPsiFile.getResolveScope());
    }

    SpringBootConfigurationMetadataParser(@NotNull Module module, @NotNull File localJsonFile) {
        if (module == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(1);
        }
        if (localJsonFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(2);
        }
        this.myAdditionalConfigTargets = new /* invalid duplicate definition of identical inner class */;
        this.myLocalModule = module;
        this.myJsonPsiFile = null;
        this.myLocalJsonFile = localJsonFile;
        this.myLibraryName = this.myLocalModule.getName();
        this.myCaching = new Caching(module.getModuleRuntimeScope(false));
    }

    @NotNull
    private static String getLibraryOrContainingJarName(@NotNull JsonFile jsonFile) {
        OrderEntry libraryEntry;
        if (jsonFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(3);
        }
        if ((libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)jsonFile.getVirtualFile(), (Project)jsonFile.getProject())) instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)libraryEntry).getLibraryName();
            if (libraryName != null) {
                String string = libraryName;
                if (string == null) {
                    SpringBootConfigurationMetadataParser.$$$reportNull$$$0(4);
                }
                return string;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getLocalByEntry(jsonFile.getVirtualFile());
            if (jarRoot != null) {
                String string = jarRoot.getName();
                if (string == null) {
                    SpringBootConfigurationMetadataParser.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        return "<unknown>";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean processKeys(@NotNull Module module, @NotNull Processor<MetaConfigKey> processor2) {
        JsonObject rootObject;
        if (module == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(7);
        }
        Ref path = Ref.create();
        try (JsonReader reader = this.openReader((Ref<String>)path);){
            reader.setLenient(true);
            JsonElement parse222 = JsonParser.parseReader((JsonReader)reader);
            if (!parse222.isJsonObject()) {
                boolean bl = true;
                return bl;
            }
            rootObject = parse222.getAsJsonObject();
        }
        catch (ProcessCanceledException ignored) {
            return true;
        }
        catch (Throwable e) {
            LOG.info("Error parsing Spring Boot metadata JSON from " + (String)path.get(), e);
            return true;
        }
        JsonElement propertiesElement = rootObject.get("properties");
        if (propertiesElement == null) {
            return true;
        }
        com.google.gson.JsonArray properties = propertiesElement.getAsJsonArray();
        Map<String, MetaConfigKey.ItemHint> hints = SpringBootConfigurationMetadataParser.getItemHints(rootObject);
        for (JsonElement element : properties) {
            Pair<MetaConfigKey.DeclarationResolveResult, PsiElement> declarationPair;
            MetaConfigKey.ItemHint keyHint;
            MetaConfigKey.ItemHint valueHint;
            JsonObject property = element.getAsJsonObject();
            String configKeyName = SpringBootConfigurationMetadataParser.getStringLiteral(property, "name");
            if (StringUtil.isEmptyOrSpaces((String)configKeyName)) continue;
            String typeLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(property, "type");
            String finalType = Comparing.strEqual((String)typeLiteral, (String)"java.util.Properties") ? "java.util.Map<java.lang.String,java.lang.String>" : typeLiteral;
            Pair<PsiType, MetaConfigKey.AccessType> typeWithAccess = SpringBootConfigurationMetadataParser.getPsiTypeToAccessType(module.getProject(), finalType);
            PsiType type = ((PsiType)typeWithAccess.getFirst()).equals(DUMMY_TYPE.getFirst()) ? null : (PsiType)typeWithAccess.getFirst();
            MetaConfigKey.AccessType accessType = (MetaConfigKey.AccessType)typeWithAccess.getSecond();
            if (accessType == MetaConfigKey.AccessType.MAP) {
                valueHint = hints.get(configKeyName + ".values");
                keyHint = hints.get(configKeyName + ".keys");
            } else {
                valueHint = hints.get(configKeyName);
                keyHint = MetaConfigKey.ItemHint.NONE;
            }
            if ((declarationPair = this.getDeclaration(property, configKeyName, type)) == null || declarationPair.second == null) continue;
            ((PsiElement)declarationPair.second).putUserData(ConfigKeyDocumentationProviderBase.CONFIG_KEY_DECLARATION_MODULE, (Object)module);
            SpringBootApplicationMetaConfigKeyImpl key = new SpringBootApplicationMetaConfigKeyImpl((PsiElement)declarationPair.second, (MetaConfigKey.DeclarationResolveResult)declarationPair.first, configKeyName, SpringBootConfigurationMetadataParser.getDescription(property), SpringBootConfigurationMetadataParser.getValueAsString(property, "defaultValue"), SpringBootConfigurationMetadataParser.getDeprecation(property), type, accessType, (MetaConfigKey.ItemHint)ObjectUtils.notNull((Object)valueHint, (Object)MetaConfigKey.ItemHint.NONE), (MetaConfigKey.ItemHint)ObjectUtils.notNull((Object)keyHint, (Object)MetaConfigKey.ItemHint.NONE));
            if (processor2.process((Object)key)) continue;
            return false;
        }
        return true;
    }

    private JsonReader openReader(Ref<String> pathRef) throws IOException {
        if (this.myJsonPsiFile != null) {
            VirtualFile file = this.myJsonPsiFile.getVirtualFile();
            pathRef.set((Object)file.getPath());
            String content = VfsUtilCore.loadText((VirtualFile)file);
            return new JsonReader((Reader)new CharSequenceReader((CharSequence)content));
        }
        assert (this.myLocalJsonFile != null);
        pathRef.set((Object)this.myLocalJsonFile.getPath());
        return new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.myLocalJsonFile)), StandardCharsets.UTF_8));
    }

    @Nullable
    private static String getValueAsString(JsonObject object, String propertyName) {
        JsonElement propertyElement = object.get(propertyName);
        if (propertyElement == null) {
            return null;
        }
        if (propertyElement.isJsonPrimitive()) {
            return propertyElement.getAsJsonPrimitive().getAsString();
        }
        if (!propertyElement.isJsonArray()) {
            return null;
        }
        com.google.gson.JsonArray array = propertyElement.getAsJsonArray();
        SmartList valueList = new SmartList();
        for (JsonElement jsonValue : array) {
            if (!jsonValue.isJsonPrimitive()) continue;
            valueList.add(jsonValue.getAsJsonPrimitive().getAsString());
        }
        return StringUtil.join((Collection)valueList, (String)", ");
    }

    @Nullable
    private Pair<MetaConfigKey.DeclarationResolveResult, PsiElement> getDeclaration(JsonObject entry, String configKeyName, PsiType type) {
        String sourceTypeText = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "sourceType");
        if (StringUtil.isEmpty((String)sourceTypeText)) {
            return this.getFallbackDeclaration(configKeyName, type, false);
        }
        PsiClass sourceTypeClass = this.myCaching.myCachedClass.get(sourceTypeText);
        if (sourceTypeClass == null) {
            return this.getFallbackDeclaration(configKeyName, type, true);
        }
        return Pair.pair((Object)MetaConfigKey.DeclarationResolveResult.PROPERTY, (Object)((Object)new SpringBootConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)sourceTypeClass, SpringBootConfigurationMetadataParser.findPropertyNavigationTarget(sourceTypeClass, configKeyName), configKeyName, sourceTypeText, type)));
    }

    @Nullable
    private Pair<MetaConfigKey.DeclarationResolveResult, PsiElement> getFallbackDeclaration(String configKeyName, PsiType type, boolean unresolvedSourceTypeClass) {
        PsiElement additionalTarget = (PsiElement)((Map)this.myAdditionalConfigTargets.getValue()).get(configKeyName);
        if (this.myJsonPsiFile != null) {
            return Pair.pair((Object)(unresolvedSourceTypeClass ? MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE : MetaConfigKey.DeclarationResolveResult.JSON), (Object)((Object)new SpringBootConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)this.myJsonPsiFile, (PsiElement)ObjectUtils.chooseNotNull((Object)additionalTarget, (Object)this.myJsonPsiFile), configKeyName, configKeyName, type)));
        }
        if (additionalTarget == null) {
            return null;
        }
        return Pair.pair((Object)MetaConfigKey.DeclarationResolveResult.ADDITIONAL_JSON, (Object)((Object)new SpringBootConfigKeyDeclarationPsiElement(this.myLibraryName, additionalTarget, additionalTarget, configKeyName, configKeyName, type)));
    }

    @NotNull
    private static PsiElement findPropertyNavigationTarget(@NotNull PsiClass sourceTypeClass, String configKeyName) {
        String propertyName;
        PsiMethod setter;
        if (sourceTypeClass == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(8);
        }
        if ((setter = PropertyUtilBase.findPropertySetter((PsiClass)sourceTypeClass, (String)(propertyName = RelaxedNames.dashedPropertyNameToCamelCase((String)configKeyName)), (boolean)false, (boolean)false)) != null) {
            PsiMethod psiMethod = setter;
            if (psiMethod == null) {
                SpringBootConfigurationMetadataParser.$$$reportNull$$$0(9);
            }
            return psiMethod;
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
        Object object = getter != null ? getter : sourceTypeClass;
        if (object == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(10);
        }
        return object;
    }

    private static MetaConfigKey.DescriptionText getDescription(JsonObject property) {
        String descriptionText = SpringBootConfigurationMetadataParser.getStringLiteral(property, "description");
        if (descriptionText == null) {
            return MetaConfigKey.DescriptionText.NONE;
        }
        return new MetaConfigKey.DescriptionText(descriptionText);
    }

    private static MetaConfigKey.Deprecation getDeprecation(JsonObject property) {
        JsonObject deprecationObject = property.getAsJsonObject("deprecation");
        if (deprecationObject != null) {
            String reasonText = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "reason");
            MetaConfigKey.DescriptionText reason = reasonText == null ? MetaConfigKey.DescriptionText.NONE : new MetaConfigKey.DescriptionText(reasonText);
            MetaConfigKey.Deprecation.DeprecationLevel level = MetaConfigKey.Deprecation.DeprecationLevel.WARNING;
            String levelLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "level");
            MetaConfigKey.Deprecation.DeprecationLevel parsedLevel = MetaConfigKey.Deprecation.DeprecationLevel.parse((String)levelLiteral);
            if (parsedLevel != null) {
                level = parsedLevel;
            }
            String replacement = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "replacement");
            return new MetaConfigKey.Deprecation(reason, level, replacement);
        }
        JsonPrimitive deprecatedProperty = property.getAsJsonPrimitive("deprecated");
        if (deprecatedProperty != null && deprecatedProperty.getAsBoolean()) {
            return MetaConfigKey.Deprecation.DEPRECATED_WITHOUT_REASON;
        }
        return MetaConfigKey.Deprecation.NOT_DEPRECATED;
    }

    private static Map<String, MetaConfigKey.ItemHint> getItemHints(JsonObject rootObject) {
        JsonElement hintsElement = rootObject.get("hints");
        if (hintsElement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, MetaConfigKey.ItemHint> itemHintsMap = new HashMap<String, MetaConfigKey.ItemHint>();
        for (JsonElement value : hintsElement.getAsJsonArray()) {
            JsonObject entry = value.getAsJsonObject();
            String nameValue = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "name");
            if (nameValue == null) continue;
            itemHintsMap.put(nameValue, SpringBootConfigurationMetadataParser.createItemHint(entry));
        }
        return itemHintsMap;
    }

    private static MetaConfigKey.ItemHint createItemHint(JsonObject entry) {
        List<MetaConfigKey.ValueProvider> providers = SpringBootConfigurationMetadataParser.getItemHintProviders(entry);
        List<MetaConfigKey.ValueHint> values = SpringBootConfigurationMetadataParser.getItemHintValues(entry);
        return new MetaConfigKey.ItemHint(providers, values);
    }

    private static List<MetaConfigKey.ValueProvider> getItemHintProviders(JsonObject entry) {
        JsonElement providersObject = entry.get("providers");
        if (providersObject == null) {
            return Collections.emptyList();
        }
        SmartList providers = new SmartList();
        for (JsonElement arrayValue : providersObject.getAsJsonArray()) {
            JsonObject providerObject;
            String name;
            if (!arrayValue.isJsonObject() || (name = SpringBootConfigurationMetadataParser.getStringLiteral(providerObject = arrayValue.getAsJsonObject(), "name")) == null) continue;
            Map<String, String> parameters = SpringBootConfigurationMetadataParser.getItemHintProviderParameters(providerObject);
            providers.add(new MetaConfigKey.ValueProvider(name, parameters));
        }
        return providers;
    }

    private static Map<String, String> getItemHintProviderParameters(JsonObject entry) {
        JsonElement parametersProperty = entry.get("parameters");
        if (parametersProperty == null || !parametersProperty.isJsonObject()) {
            return Collections.emptyMap();
        }
        JsonObject parametersObject = parametersProperty.getAsJsonObject();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (Map.Entry parameterProperty : parametersObject.entrySet()) {
            JsonElement value = (JsonElement)parameterProperty.getValue();
            if (value == null || !value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            parameters.put((String)parameterProperty.getKey(), primitive.getAsString());
        }
        return parameters;
    }

    private static List<MetaConfigKey.ValueHint> getItemHintValues(JsonObject entry) {
        JsonElement valuesObject = entry.get("values");
        if (valuesObject == null || !valuesObject.isJsonArray()) {
            return Collections.emptyList();
        }
        SmartList values = new SmartList();
        for (JsonElement arrayValue : valuesObject.getAsJsonArray()) {
            JsonObject valueObject;
            String value;
            if (!arrayValue.isJsonObject() || (value = SpringBootConfigurationMetadataParser.getStringLiteral(valueObject = arrayValue.getAsJsonObject(), "value")) == null) continue;
            values.add(new MetaConfigKey.ValueHint(value, SpringBootConfigurationMetadataParser.getDescription(valueObject)));
        }
        return values;
    }

    @Nullable
    private static String getStringLiteral(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        return property != null ? property.getAsString() : null;
    }

    private static Pair<PsiType, MetaConfigKey.AccessType> getPsiTypeToAccessType(Project project, String type) {
        Map myCachedTypes = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiElementFactory myElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            ConcurrentMap myFactoryMap = ConcurrentFactoryMap.createMap(arg_0 -> SpringBootConfigurationMetadataParser.lambda$getPsiTypeToAccessType$0((PsiJavaParserFacade)myElementFactory, arg_0));
            return CachedValueProvider.Result.create((Object)myFactoryMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (Pair)myCachedTypes.get(type);
    }

    private static /* synthetic */ Pair lambda$getPsiTypeToAccessType$0(PsiJavaParserFacade myElementFactory, String key) {
        if (key == null) {
            return DUMMY_TYPE;
        }
        try {
            PsiType psiType = myElementFactory.createTypeFromText(key.replace('$', '.'), null);
            return Pair.create((Object)psiType, (Object)MetaConfigKey.AccessType.forPsiType((PsiType)psiType));
        }
        catch (IncorrectOperationException e) {
            return DUMMY_TYPE;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonPsiFile";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localJsonFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryOrContainingJarName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyNavigationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryOrContainingJarName";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyNavigationTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Caching {
        private final Map<String, PsiClass> myCachedClass;

        private Caching(GlobalSearchScope scope) {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)scope.getProject());
            this.myCachedClass = FactoryMap.create(key -> javaPsiFacade.findClass(key.replace('$', '.'), scope));
        }
    }
}

