/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ProcessingContext;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DurationReferenceProvider
extends HintReferenceProviderBase {
    private static final Pattern ISO8601 = Pattern.compile("^[+\\-]?P.*$");
    private static final Pattern SB2_PATTERN = Pattern.compile("^([+\\-]?\\d+)(ns|us|ms|s|m|h|d)$", 2);

    DurationReferenceProvider() {
    }

    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        return new HintReferenceBase(element, textRange){

            @Nullable
            protected PsiElement doResolve() {
                String value = this.getValue();
                if (ISO8601.matcher(value).matches()) {
                    try {
                        Duration.parse(value);
                        return this.getElement();
                    }
                    catch (DateTimeParseException e) {
                        return null;
                    }
                }
                if (!this.isSpringBoot2()) {
                    return null;
                }
                if (SB2_PATTERN.matcher(value).matches()) {
                    return this.getElement();
                }
                try {
                    Long.decode(value);
                    return this.getElement();
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            private boolean isSpringBoot2() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0);
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                return "Value ''{0}'' is not a valid duration";
            }
        };
    }
}

