/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceUtils;
import com.intellij.util.ProcessingContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataSizeReferenceProvider
extends HintReferenceProviderBase {
    @NonNls
    private static final String ALL_DATA_UNIT_SUFFIXES = StringUtil.join((Object[])DataUnit.values(), unit -> unit.getSuffix(), (String)"|");
    @NonNls
    private static final Pattern PATTERN = Pattern.compile("^([+\\-]?\\d+)(" + ALL_DATA_UNIT_SUFFIXES + ")$");

    DataSizeReferenceProvider() {
    }

    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, final ProcessingContext context) {
        return new HintReferenceBase(element, textRange){

            @Nullable
            protected PsiElement doResolve() {
                return this.getResolveMessage() == null ? this.getElement() : null;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = "Invalid DataSize: " + this.getResolveMessage();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            private String getResolveMessage() {
                Long decodedValue;
                String value;
                String numberValue = value = this.getValue();
                DataUnit dataUnit = null;
                Matcher matcher = PATTERN.matcher(value);
                if (matcher.matches()) {
                    String unit = matcher.group(2);
                    dataUnit = DataUnit.fromString(unit);
                    numberValue = value.substring(0, value.length() - unit.length());
                }
                try {
                    decodedValue = Long.decode(numberValue);
                    if (dataUnit == DataUnit.BYTES) {
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    return "cannot convert '" + numberValue + "' to Long";
                }
                if (dataUnit == null) {
                    MetaConfigKey configKey = (MetaConfigKey)context.get(SpringBootHintReferencesProvider.HINT_REFERENCES_CONFIG_KEY);
                    PsiAnnotation dataSizeUnitAnno = HintReferenceUtils.findAnnotationOnConfigPropertyField(configKey, "org.springframework.boot.convert.DataSizeUnit");
                    if (dataSizeUnitAnno != null) {
                        dataUnit = (DataUnit)JamCommonUtil.getEnumValue((PsiAnnotationMemberValue)dataSizeUnitAnno.findAttributeValue("value"), DataUnit.class);
                    }
                    if (dataUnit == null) {
                        dataUnit = DataUnit.BYTES;
                    }
                }
                try {
                    Math.multiplyExact((long)decodedValue, dataUnit.getBytes());
                }
                catch (ArithmeticException e) {
                    return "overflow [" + dataUnit.getSuffix() + "]";
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/DataSizeReferenceProvider$1", "getUnresolvedMessagePattern"));
            }
        };
    }

    private static enum DataUnit {
        BYTES("B", 1L),
        KILOBYTES("KB", 1024L),
        MEGABYTES("MB", 0x100000L),
        GIGABYTES("GB", 0x40000000L),
        TERABYTES("TB", 0x10000000000L);

        private final String suffix;
        private final long bytes;

        private DataUnit(String suffix, long bytes) {
            this.suffix = suffix;
            this.bytes = bytes;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public long getBytes() {
            return this.bytes;
        }

        @Nullable
        public static DataUnit fromString(String value) {
            for (DataUnit unit : DataUnit.values()) {
                if (!unit.getSuffix().equals(value)) continue;
                return unit;
            }
            return null;
        }
    }
}

