/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import org.jetbrains.annotations.Nullable;

class SpringBootConfigFileUsageTypeProvider
implements UsageTypeProvider {
    private static final UsageType CONFIGURATION_FILE_USAGE_TYPE = new UsageType(SpringBootApiBundle.messagePointer("application.config.usage.type", new Object[0]));
    private static final UsageType ADDITIONAL_METADATA_USAGE_TYPE = new UsageType(SpringBootApiBundle.messagePointer("additional.config.usage.type", new Object[0]));

    SpringBootConfigFileUsageTypeProvider() {
    }

    @Nullable
    public UsageType getUsageType(PsiElement element) {
        Project project = element.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project) || !SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType == JsonFileType.INSTANCE) {
            if (virtualFile.getName().equals("additional-spring-configuration-metadata.json")) {
                return ADDITIONAL_METADATA_USAGE_TYPE;
            }
            return null;
        }
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            if (contributor.getFileType() != fileType || !contributor.getConfigurationFiles(module, true).contains(virtualFile)) continue;
            return CONFIGURATION_FILE_USAGE_TYPE;
        }
        return null;
    }
}

