/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenResolver;
import com.intellij.spring.spi.SpringSpiClassesListJamConverter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootConfigFileAnnotatorBase
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    @Nullable
    protected abstract TextAttributesKey getPlaceholderTextAttributesKey();

    @Nullable
    protected TextAttributesKey getReplacementTokenTextAttributesKey() {
        return DefaultLanguageHighlighterColors.METADATA;
    }

    protected void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(1);
        }
        int elementOffset = element.getNode().getStartOffset();
        Object[] references = element.getReferences();
        boolean highlightOnlyPlaceholders = ContainerUtil.findInstance((Object[])references, SpringBootPlaceholderReference.class) != null;
        IntOpenHashSet annotatedOffsets = new IntOpenHashSet();
        for (Object reference : references) {
            TextRange highlightTextRange;
            TextAttributesKey key = null;
            if (highlightOnlyPlaceholders) {
                if (reference instanceof SpringBootPlaceholderReference) {
                    key = this.getPlaceholderTextAttributesKey();
                }
            } else if (reference instanceof JavaClassReference || reference instanceof SpringSpiClassesListJamConverter.SpringSpiClassReference || reference instanceof PsiPackageReference) {
                if (reference.resolve() != null) {
                    key = DefaultLanguageHighlighterColors.CLASS_REFERENCE;
                }
            } else if (reference instanceof SpringBootReplacementTokenResolver.ReplacementTokenReference) {
                key = this.getReplacementTokenTextAttributesKey();
            } else if (reference instanceof HintReferenceBase) {
                key = ((HintReferenceBase)reference).getTextAttributesKey();
            }
            if (key == null || !annotatedOffsets.add((highlightTextRange = reference.getRangeInElement().shiftRight(elementOffset)).getStartOffset())) continue;
            SpringBootConfigFileAnnotatorBase.doAnnotate(holder, highlightTextRange, key);
        }
    }

    protected static void doAnnotate(AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        if (range.isEmpty()) {
            return;
        }
        (DEBUG_MODE ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(range).textAttributes(key).create();
    }

    protected static void doAnnotateEnforced(AnnotationHolder holder, TextRange range, SimpleTextAttributes key, String debugMessage) {
        if (range.isEmpty()) {
            return;
        }
        String message = DEBUG_MODE ? debugMessage : null;
        (message != null ? holder.newAnnotation(HighlightSeverity.INFORMATION, message) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(range).enforcedTextAttributes(key.toTextAttributes()).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/SpringBootConfigFileAnnotatorBase";
        objectArray[2] = "annotateValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

